package dev.amble.ait.client.sounds.engine;

import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.sounds.PositionedLoopingSound;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.EngineBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;

public class EngineLoopSound extends PositionedLoopingSound {
    private int ticks = 0;

    public EngineLoopSound() {
        super(AITSounds.ENGINE_LOOP, class_3419.field_15245, new class_2338(0, 0, 0), AITModClient.CONFIG.engineLoopVolume);
    }

    @Override
    public void method_16896() {
        super.method_16896();
        this.ticks++;

        if (this.ticks >= (40)) {
            this.refresh();
        }
    }

    public void refresh() {

        class_2338 nearestEngine = ClientTardisUtil.getNearestEngine();
        class_1937 world = class_310.method_1551().field_1687;
        boolean isEngineBlockEntity = world != null && world.method_8321(nearestEngine) instanceof EngineBlockEntity;

        this.setPosition(nearestEngine);

        if (isEngineBlockEntity) {
            this.setVolume(AITModClient.CONFIG.engineLoopVolume);
        } else {
            this.setVolume(0);
        }
        this.ticks = 0;
    }
}
