package dev.amble.ait.client.sounds.hum.exterior;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.client.sounds.PositionedLoopingSound;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.data.hum.Hum;

public class ExteriorHumSound extends PositionedLoopingSound implements Linkable {
    private Hum data;
    private int ticks = 0;
    private boolean dirty = true;
    private TardisRef tardis;
    private float multiplier = 1f;

    public ExteriorHumSound(Hum data, class_3419 soundCategory) {
        super(data.sound(), soundCategory, new class_2338(0,0,0));
        this.data = data;
    }

    @Override
    public void method_16896() {
        super.method_16896();
        this.ticks++;

        this.refresh();
    }

    public void refresh() {
        // make quieter if doors closed
        if (this.isLinked()) {
            this.multiplier = tardis.get().door().isOpen() ? 0.25f : 0.05f;

            this.fixDistance();

            // find new nearest tardis every 5 seconds
            if (this.ticks % 100 == 0) {
                this.dirty = true;
                this.ticks = 0;
            }
        }
    }
    private void fixDistance() {
        // adjust volume based off distance
        // ( hum sounds are stereo )
        if (this.isLinked()) {
            class_2338 tPos = tardis.get().travel().position().getPos();

            double distance = Math.sqrt(tPos.method_19770(class_310.method_1551().field_1724.method_19538()));
            this.field_5442 = (float) Math.max(0, (1 - ((distance / ExteriorHumHandler.MAX_DISTANCE))) * multiplier);

            if (!this.getPosition().equals(tPos)) {
                this.setPosition(tPos);
            }
        }
    }

    public Hum getData() {
        if (this.data == null) {
            Optional<ClientTardis> nearest = ClientTardisUtil.getNearestTardis(ExteriorHumHandler.MAX_DISTANCE);
            nearest.ifPresent(this::link);
        }

        return this.data;
    }
    public boolean isDirty() {
        return this.dirty;
    }
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void link(Tardis tardis) {
        this.tardis = TardisRef.createAs(class_310.method_1551().field_1724, tardis);
        this.data = tardis.hum().get();
    }

    @Override
    public void link(UUID id) {
        this.tardis = TardisRef.createAs(class_310.method_1551().field_1724, id);
    }

    @Override
    public TardisRef tardis() {
        return this.tardis;
    }

}
