package dev.amble.ait.client.sounds.hum.interior;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.sounds.LoopingSound;
import dev.amble.ait.client.sounds.PlayerFollowingLoopingSound;
import dev.amble.ait.client.sounds.PlayerFollowingSound;
import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.CreakSound;
import dev.amble.ait.registry.impl.CreakRegistry;

public class ClientCreakHandler extends SoundHandler {

    private static final Random random = new Random();

    public static ClientCreakHandler create() {
        ClientCreakHandler handler = new ClientCreakHandler();

        handler.generateCreaks();
        return handler;
    }

    private void generateCreaks() {
        this.sounds = this.registryToList();
    }

    /**
     * Converts all the {@link CreakSound}'s in the {@link CreakRegistry} to
     * {@link LoopingSound} so they are usable
     *
     * @return A list of {@link LoopingSound} from the {@link CreakRegistry}
     */
    private List<class_1113> registryToList() {
        List<class_1113> list = new ArrayList<>();

        for (CreakSound sound : CreakRegistry.REGISTRY) {
            list.add(new PlayerFollowingLoopingSound(sound.sound(), class_3419.field_15256,
                    AITModClient.CONFIG.interiorHumVolume));
        }

        return list;
    }

    public class_2338 randomNearConsolePos(class_2338 consolePos) {
        return consolePos.method_10069(random.nextInt(8) - 1, 0, random.nextInt(8) - 1);
    }

    public void playRandomCreak(ClientTardis current) {
        CreakSound chosen = CreakRegistry.getRandomCreak();

        if (current.siege().isActive() && chosen.equals(CreakRegistry.WHISPER)) {
            current.getDesktop().getConsolePos()
                    .forEach(console -> startIfNotPlaying(
                            new class_1109(chosen.sound(), class_3419.field_15251, 0.5f, 1.0f,
                                    net.minecraft.class_5819.method_43047(), randomNearConsolePos(console))));

            return;
        } else if (chosen.equals(CreakRegistry.WHISPER)) {
            return;
        }

        PlayerFollowingSound following = new PlayerFollowingSound(chosen.sound(), class_3419.field_15256,
                AITModClient.CONFIG.interiorHumVolume);
        startIfNotPlaying(following);
    }

    public void tick(class_310 client) {
        if (this.sounds == null)
            this.generateCreaks();

        ClientTardis current = ClientTardisUtil.getCurrentTardis();

        if (current == null) {
            this.stopSounds();
            return;
        }

        // todo should they play even with power? just make them more rare??
        if (current.fuel().hasPower()
                && (current.travel().getState() == TravelHandlerBase.State.LANDED || current.travel().autopilot())) {
            this.stopSounds();
            return;
        }

        // theyre in a tardis and theres no power so play creaks boi
        if (random.nextInt(512) == 32)
            this.playRandomCreak(current);
    }
}
