package dev.amble.ait.client.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(EnvType.CLIENT)
public class AngleInterpolator {
    private double value;
    private double speed;
    private long lastUpdateTime;

    public AngleInterpolator() {
    }

    public double value() {
        return value;
    }

    public boolean shouldUpdate(long time) {
        return this.lastUpdateTime != time;
    }

    public void update(long time, double target) {
        this.lastUpdateTime = time;
        double d = target - this.value;
        d = class_3532.method_15367(d + 0.5, 1.0) - 0.5;
        this.speed += d * 0.1;
        this.speed *= 0.8;
        this.value = class_3532.method_15367(this.value + this.speed, 1.0);
    }
}