package dev.amble.ait.client.util;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_918;

public class ClientItemUtil {

    private static final class_5819 RANDOM = class_5819.method_43049(42L);
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public static void renderBakedItemModel(class_1087 model, int color, int light, int overlay, class_4587 matrices,
            class_4597 provider) {
        renderBakedItemModel(model, color, light, overlay, matrices, class_918.method_29711(provider,
                class_4722.method_24076(), true, false));
    }

    public static void renderBakedItemModel(class_1087 model, int color, int light, int overlay, class_4587 matrices,
            class_4588 vertices) {
        for (class_2350 direction : DIRECTIONS) {
            renderBakedItemQuads(matrices, vertices, model.method_4707(null, direction, RANDOM), color, light, overlay);
        }

        renderBakedItemQuads(matrices, vertices, model.method_4707(null, null, RANDOM), color, light, overlay);
    }

    private static void renderBakedItemQuads(class_4587 matrices, class_4588 vertices, List<class_777> quads,
            int color, int light, int overlay) {
        class_4587.class_4665 entry = matrices.method_23760();

        for (class_777 quad : quads) {
            int i = quad.method_3360() ? color : -1;

            float f = (float) (i >> 16 & 255) / 255.0F;
            float g = (float) (i >> 8 & 255) / 255.0F;
            float h = (float) (i & 255) / 255.0F;
            vertices.method_22919(entry, quad, f, g, h, light, overlay);
        }
    }
}
