package dev.amble.ait.client.util;


import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ClientShakeUtil {
    private static final float SHAKE_CLAMP = 45.0f; // Adjust this value to set the maximum shake angle
    private static final float SHAKE_INTENSITY = 0.5f; // Adjust this value to control the intensity of the shake
    private static final int MAX_DISTANCE = 16; // The radius from the console where the player will feel the shake

    public static boolean shouldShake(Tardis tardis) {
        if (ClientTardisUtil.getCurrentTardis() != tardis)
            return false;

        if (tardis.flight().falling().get())
            return true;

        return !tardis.travel().autopilot() && tardis.travel().getState() != TravelHandlerBase.State.LANDED;
    }

    /**
     * Shakes based off the distance of the player from the console
     */
    public static void shakeFromConsole() {
        shake(1f - (float) (ClientTardisUtil.distanceFromConsole() / MAX_DISTANCE));
    }

    public static void shakeFromEverywhere() {
        shake(0.1f);
    }

    public static void shake(float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null)
            return;

        float targetPitch = getShakeX(client.field_1724.method_36455(), scale);
        float targetYaw = getShakeY(client.field_1724.method_36454(), scale);

        client.field_1724.method_36457(class_3532.method_16439(SHAKE_INTENSITY, client.field_1724.method_36455(), targetPitch));
        client.field_1724.method_36456(class_3532.method_16439(SHAKE_INTENSITY, client.field_1724.method_36454(), targetYaw));
    }

    private static float getShakeY(float baseYaw, float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null)
            return baseYaw;

        float temp = (client.field_1724.method_6051().method_43057() * scale);
        float shakeYaw = baseYaw + (client.field_1724.method_6051().method_43056() ? temp : -temp);

        return class_3532.method_15363(shakeYaw, baseYaw - SHAKE_CLAMP, baseYaw + SHAKE_CLAMP);
    }

    private static float getShakeX(float basePitch, float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null)
            return basePitch;

        float temp = (client.field_1724.method_6051().method_43057() * (scale / 2));
        float shakePitch = basePitch + (client.field_1724.method_6051().method_43056() ? temp : -temp);

        return class_3532.method_15363(shakePitch, basePitch - SHAKE_CLAMP, basePitch + SHAKE_CLAMP);
    }
}
