package dev.amble.ait.compat.jei.client;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Renders inputs for Fabricator recipes in JEI with a range, rather than a specific number of items
 */
public class BlueprintInputItemStackRenderer implements IIngredientRenderer<class_1799> {

    private final int minCount;
    private final int maxCount;

    public BlueprintInputItemStackRenderer(int minCount, int maxCount) {
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public void render(class_332 context, @Nullable class_1799 maxCountStack) {
        this.render(context, maxCountStack, 0, 0);
    }

    public void render(class_332 context, @Nullable class_1799 ingredient, int posX, int posY) {
        if (ingredient == null) {
            return;
        }
        RenderSystem.enableDepthTest();

        class_310 minecraft = class_310.method_1551();
        context.method_51445(ingredient, posX, posY);

        class_327 textRenderer = this.getFontRenderer(minecraft, ingredient);
        context.method_51432(textRenderer, ingredient, posX, posY, "");
        this.drawText(context, textRenderer, posX, posY);

        RenderSystem.disableBlend();
    }

    private static final int TEXT_COLOR = 16777215;

    /**
     * Custom text drawing method to fit the range of items within the item slot
     */
    private void drawText(class_332 context, class_327 textRenderer, int posX, int posY) {
        String range;
        if (minCount == maxCount) {
            if (minCount == 1)
                return;
            range = String.valueOf(minCount);
        } else {
            range = minCount + "-" + maxCount;
        }

        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0F, 0.0F, 200.0F);

        if (textRenderer.method_1727(range) > 26) {
            context.method_51433(
                    textRenderer,
                    String.valueOf(minCount),
                    posX + 20 - textRenderer.method_1727(String.valueOf(minCount)),
                    posY + 4,
                    TEXT_COLOR,
                    true
            );
            context.method_51433(
                    textRenderer,
                    "-" + maxCount,
                    posX + 20 - textRenderer.method_1727("-" + maxCount),
                    posY + 12,
                    TEXT_COLOR,
                    true
            );
        } else {
            context.method_51433(
                    textRenderer,
                    range,
                    posX + 20 - textRenderer.method_1727(range),
                    posY + 12,
                    TEXT_COLOR,
                    true
            );
        }
        matrixStack.method_22909();
    }

    /**
     * This is both required and deprecated for some reason so it has to be here
     */
    @Override
    public @NotNull List<class_2561> getTooltip(class_1799 ingredient, class_1836 tooltipFlag) {
        return List.of();
    }


    public void getTooltip(ITooltipBuilder tooltip, class_1799 ingredient, class_1836 tooltipFlag) {
        class_310 minecraft = class_310.method_1551();
        class_1657 player = minecraft.field_1724;
        List<class_2561> components = ingredient.method_7950(player, tooltipFlag);
        tooltip.addAll(components);
    }

}
