package dev.amble.ait.compat.permissionapi;

import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import dev.amble.ait.compat.DependencyChecker;

public class PermissionAPICompat implements ModInitializer {

    private static PermissionCheck CHECKER = (ctx, permission, level) -> ctx.method_9259(level);

    @FunctionalInterface
    public interface PermissionCheck {
        boolean hasPermission(class_2168 ctx, String permission, int level);
    }

    @Override
    public void onInitialize() {
        if (DependencyChecker.hasPermissionApi()) CHECKER = Permissions::check;
    }

    // Public static method to use the permission check lambda
    public static boolean hasPermission(class_2168 ctx, String permission, int level) {
        return CHECKER.hasPermission(ctx, permission, level);
    }
}
