package dev.amble.ait.compat.portal;

import dev.amble.ait.AITMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6367;
import net.minecraft.class_7924;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.DQuaternion;

import java.util.Optional;
import java.util.WeakHashMap;

public class PortalVisualizerUtil {

    public static final class_2960 OPEN_VISUALIZER = AITMod.id("ip/visualizer/open");
    public static final class_2960 CLOSE_VISUALIZER = AITMod.id("ip/visualizer/close");

    /**
     * The Framebuffer that the GUI portal is going to render onto
     */
    @Environment(EnvType.CLIENT)
    private static class_276 frameBuffer;
    
    private static final WeakHashMap<class_3222, ChunkLoader>
        chunkLoaderMap = new WeakHashMap<>();

    public static void init() {
        PortalsAPI.VISUALIZER = Optional.of(PortalVisualizerUtil::open);

        ServerPlayNetworking.registerGlobalReceiver(CLOSE_VISUALIZER, (server, player, handler, buf, sender) -> {
            server.execute(() -> removeChunkLoaderFor(player));
        });
    }

    @Environment(EnvType.CLIENT)
    public static void clientInit() {
        ClientPlayNetworking.registerGlobalReceiver(OPEN_VISUALIZER, (client, handler, buf, sender) -> {
            class_5321<class_1937> dim = buf.method_44112(class_7924.field_41223);
            class_2338 pos = buf.method_10811();

            client.execute(() -> {
                if (frameBuffer == null) frameBuffer = new class_6367(2, 2, true, true);

                client.method_1507(new GuiPortalScreen(dim, pos.method_46558()));
            });
        });
    }
    
    private static void removeChunkLoaderFor(class_3222 player) {
        ChunkLoader chunkLoader = chunkLoaderMap.remove(player);
        if (chunkLoader != null) {
            PortalAPI.removeChunkLoaderForPlayer(player, chunkLoader);
        }
    }
    
    public static void open(class_3222 player, class_3218 world, class_2338 pos) {
        removeChunkLoaderFor(player);
        
        ChunkLoader chunkLoader = new ChunkLoader(
            new DimensionalChunkPos(
                world.method_27983(), new class_1923(pos)
            ),
            8
        );
        
        // Add the per-player additional chunk loader
        PortalAPI.addChunkLoaderForPlayer(player, chunkLoader);
        chunkLoaderMap.put(player, chunkLoader);
        
        // Tell the client to open the screen
        class_2540 buf = PacketByteBufs.create();
        buf.method_44116(world.method_27983());
        buf.method_10807(pos);

        ServerPlayNetworking.send(player, OPEN_VISUALIZER, buf);
    }

    @Environment(EnvType.CLIENT)
    public static class GuiPortalScreen extends class_437 {

        private static final class_2960 TEXTURE = AITMod.id("textures/gui/tardis/monitor/visualizer_menu.png");
        private static final class_2960 OVERLAY = AITMod.id("textures/gui/tardis/monitor/visualizer_overlay.png");

        private static final int bgHeight = 154;
        private static final int bgWidth = 256;

        private static final int bgBorder = 9;

        private final class_5321<class_1937> viewingDimension;
        
        private final class_243 viewingPosition;
        
        public GuiPortalScreen(class_5321<class_1937> viewingDimension, class_243 viewingPosition) {
            super(class_2561.method_43471("screen.ait.visualizer.title"));

            this.viewingDimension = viewingDimension;
            this.viewingPosition = viewingPosition;
        }
        
        @Override
        public void method_25419() {
            super.method_25419();
            
            ClientPlayNetworking.send(CLOSE_VISUALIZER, PacketByteBufs.create());
        }

        @Override
        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            int top = (this.field_22790 - bgHeight) / 2;
            int left = (this.field_22789 - bgWidth) / 2;

            context.method_25302(TEXTURE, left, top, 0, 0, bgWidth, bgHeight);

            double t1 = CHelper.getSmoothCycles(503);

            // Determine the camera transformation
            Matrix4f cameraTransformation = new Matrix4f();
            cameraTransformation.identity();
            cameraTransformation.mul(
                    DQuaternion.rotationByDegrees(
                            new class_243(0, 1, 0).method_1029(),
                            t1 * 360
                    ).toMatrix()
            );

            // Create the world render info
            WorldRenderInfo worldRenderInfo = new WorldRenderInfo.Builder()
                    .setWorld(ClientWorldLoader.getWorld(viewingDimension))
                    .setCameraPos(viewingPosition)
                    .setCameraTransformation(cameraTransformation)
                    .setOverwriteCameraTransformation(true) // do not apply camera transformation to existing player camera transformation
                    .setDescription(null)
                    .setRenderDistance(field_22787.field_1690.method_38521())
                    .setDoRenderHand(false)
                    .setEnableViewBobbing(false)
                    .setDoRenderSky(false)
                    .setHasFog(false)
                    .build();

            // Ask it to render the world into the framebuffer the next frame
            GuiPortalRendering.submitNextFrameRendering(worldRenderInfo, frameBuffer);

            float scale = (float) field_22787.method_22683().method_4495();

            // Draw the framebuffer
            MyRenderHelper.drawFramebuffer(
                    frameBuffer,
                    true, // enable alpha blend
                    false, // don't modify alpha
                    (left + bgBorder) * scale, (left + bgWidth - bgBorder) * scale,
                    (top + bgBorder) * scale, (top + bgHeight - bgBorder) * scale
            );

            context.method_25302(OVERLAY, left, top, 0, 0, bgWidth, bgHeight);
        }

        @Override
        public boolean method_25421() {
            return false;
        }

        // close when E is pressed
        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            
            if (field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.method_25419();
                return true;
            }
            
            return false;
        }
    }
}