package dev.amble.ait.compat.portal;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.EntityRef;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.data.DirectedGlobalPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_7718;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalsHandler extends KeyedTardisComponent {

	public static final IdLike ID = new AbstractId<>("PORTALS", PortalsHandler::new, PortalsHandler.class);

	@Nullable
	private EntityRef<TardisPortal> interiorRef;

	@Nullable
	private EntityRef<TardisPortal> exteriorRef;

	public PortalsHandler() {
		super(ID);
	}

	@Override
	public void postInit(InitContext ctx) {
		if (this.isClient() || ctx.created())
			return;

		if (this.exteriorRef != null) {
			class_3218 exteriorWorld = tardis.travel().position().getWorld();
			this.exteriorRef.setWorld(exteriorWorld);
		}

		if (this.interiorRef != null) {
			class_3218 interiorWorld = tardis.asServer().world();
			this.interiorRef.setWorld(interiorWorld);
		}
	}

	public static void init() {
        class_2378.method_10230(class_7923.field_41177, AITMod.id("ip_portal"), TardisPortal.ENTITY_TYPE);

        if (!AITMod.CONFIG.allowPortalsBoti) return;

		TardisComponentRegistry.getInstance().register(ID);

		// TODO: re-use the same two portal entities
		//  for exterior changing this could be achieved by moving the portals & changing their size
		//  for opening and closing doors, portals' rendering can be turned off

		TardisEvents.DOOR_OPEN.register((tdis) -> {
			PortalsHandler handler = tdis.handler(ID);
			handler.generatePortals();
		});

		TardisEvents.REAL_DOOR_CLOSE.register((tdis) -> {
			PortalsHandler handler = tdis.handler(ID);
			handler.removePortals();
		});

		TardisEvents.DOOR_MOVE.register((tdis, newPos, oldPos) -> {
			PortalsHandler handler = tdis.handler(ID);
			handler.removePortals();

			if (tdis.door().isOpen()) handler.generatePortals();
		});

		TardisEvents.EXTERIOR_CHANGE.register((tdis) -> {
			PortalsHandler handler = tdis.handler(ID);
			handler.removePortals();

			if (tdis.door().isOpen()) handler.generatePortals();
		});

        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            class_2596<?> dimSyncPacket = MiscNetworking.createDimSyncPacket();
            serverPlayNetworkHandler.method_14364(dimSyncPacket);
        });

        PortalVisualizerUtil.init();
	}

	@Environment(EnvType.CLIENT)
	public static void clientInit() {
		// TODO: make it so doors don't render twice.
		//  > maybe we should just cancel door rendering when there's BOTI present?
		//  > ...idk, need to discuss this - Theo

        PortalVisualizerUtil.clientInit();

        if (TardisPortal.ENTITY_TYPE != null)
            EntityRendererRegistry.register(TardisPortal.ENTITY_TYPE, PortalEntityRenderer::new);
	}

	public TardisPortal getInterior() {
		return this.interiorRef != null ? this.interiorRef.get() : null;
	}

	public TardisPortal getExterior() {
		return this.exteriorRef != null ? this.exteriorRef.get() : null;
	}

	private void generatePortals() {
		CachedDirectedGlobalPos exteriorPos = this.tardis().travel().position();

		DirectedBlockPos tempPos = this.tardis().getDesktop().getDoorPos();
		CachedDirectedGlobalPos interiorPos = CachedDirectedGlobalPos.create(tardis().asServer().world(), tempPos.getPos(), tempPos.getRotation());

		removePortals();

        if (!tardis.getExterior().getVariant().hasPortals()) return;

		this.exteriorRef = new EntityRef<>(exteriorPos.getWorld(), createExteriorPortal());
		this.interiorRef = new EntityRef<>(interiorPos.getWorld(), createInteriorPortal());
	}

    private TardisPortal createExteriorPortal() {
        DirectedBlockPos doorPos = tardis.getDesktop().getDoorPos();
        CachedDirectedGlobalPos exteriorPos = tardis.travel().getState() == TravelHandlerBase.State.LANDED
                ? tardis.travel().position() : tardis.travel().getProgress();

        class_243 doorAdjust = adjustInteriorPos(tardis.getExterior().getVariant().door(), doorPos);
        class_243 exteriorAdjust = adjustExteriorPos(tardis.getExterior().getVariant(), exteriorPos);

        TardisPortal portal = new TardisPortal(tardis.travel().getState() == TravelHandlerBase.State.FLIGHT ? WorldUtil.getTimeVortex() : exteriorPos.getWorld());

        portal.setOrientationAndSize(
                new class_243(1, 0, 0), // axisW
                new class_243(0, 1, 0), // axisH
                tardis.getExterior().getVariant().portalWidth(), // width
                tardis.getExterior().getVariant().portalHeight() // height
        );

        DQuaternion quat = DQuaternion.rotationByDegrees(new class_243(0, -1, 0), 180 + class_7718.method_45482(exteriorPos.getRotation()));
        DQuaternion doorQuat = DQuaternion.rotationByDegrees(new class_243(0, -1, 0), class_7718.method_45482(doorPos.getRotation()));

        PortalAPI.setPortalOrientationQuaternion(portal, quat);
        portal.setOtherSideOrientation(doorQuat);

        portal.setOriginPos(exteriorAdjust);

        portal.setDestinationDimension(tardis.asServer().world().method_27983());
        portal.setDestination(doorAdjust);

        //portal.renderingMergable = true;
        portal.setInteractable(false);
        portal.method_37908().method_8649(portal);

        return portal;
    }

    private TardisPortal createInteriorPortal() {
        DirectedBlockPos doorPos = tardis.getDesktop().getDoorPos();
        CachedDirectedGlobalPos exteriorPos = tardis.travel().getState() == TravelHandlerBase.State.LANDED
                ? tardis.travel().position() : tardis.travel().getProgress();

        class_243 doorAdjust = adjustInteriorPos(tardis.getExterior().getVariant().door(), doorPos);
        class_243 exteriorAdjust = adjustExteriorPos(tardis.getExterior().getVariant(), exteriorPos);

        TardisPortal portal = new TardisPortal(tardis.asServer().world());

        portal.setOrientationAndSize(
                new class_243(1, 0, 0), // axisW
                new class_243(0, 1, 0), // axisH
                tardis.getExterior().getVariant().portalWidth(), // width
                tardis.getExterior().getVariant().portalHeight() // height
        );

        DQuaternion quat = DQuaternion.rotationByDegrees(new class_243(0, -1, 0), class_7718.method_45482(doorPos.getRotation()));
        DQuaternion extQuat = DQuaternion.rotationByDegrees(new class_243(0, -1, 0), 180 + class_7718.method_45482(exteriorPos.getRotation()));

        PortalAPI.setPortalOrientationQuaternion(portal, quat);
        portal.setOtherSideOrientation(extQuat);

        portal.setOriginPos(doorAdjust);

        portal.setDestinationDimension(tardis.travel().getState() == TravelHandlerBase.State.FLIGHT ? AITDimensions.TIME_VORTEX_WORLD : exteriorPos.getWorld().method_27983());
        portal.setDestination(exteriorAdjust);

        //portal.renderingMergable = true;w
        portal.setInteractable(false);
        portal.method_37908().method_8649(portal);

        return portal;
    }

    private static class_243 adjustExteriorPos(ExteriorVariantSchema exterior, DirectedGlobalPos directed) {
        return exterior.getPortalPosition(directed.getPos().method_46558(), directed.getRotationDegrees()).method_1031(0, 0.75f, 0);
    }

    private static class_243 adjustInteriorPos(DoorSchema door, DirectedBlockPos directed) {
        return door.getPortalPosition(directed.getPos().method_46558(),
		        class_7718.method_45482(directed.getRotation())
        ).method_1031(0, 0.55f, 0);
    }

	private void removePortals() {
		removePortal(this.getInterior());
		removePortal(this.getExterior());
	}

	private static void removePortal(Portal portal) {
		if (portal == null)
			return;

		PortalManipulation.removeConnectedPortals(portal, (p) -> {});
		portal.method_31472();
	}
}
