package dev.amble.ait.core;


import static dev.amble.ait.core.AITItems.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import dev.amble.lib.block.ABlockSettings;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.NoBlockItem;
import dev.amble.lib.datagen.util.AutomaticModel;
import dev.amble.lib.datagen.util.NoBlockDrop;
import dev.amble.lib.datagen.util.NoEnglish;
import dev.amble.lib.datagen.util.PickaxeMineable;
import dev.amble.lib.item.AItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;

import net.minecraft.block.*;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_5541;
import net.minecraft.class_5542;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blocks.*;
import dev.amble.ait.core.blocks.control.RedstoneControlBlock;
import dev.amble.ait.core.engine.block.generic.GenericSubSystemBlock;


public class AITBlocks extends BlockContainer {
    public static class_2248 SNOW_GLOBE;
    @NoBlockItem
    @NoBlockDrop
    @NoEnglish
    public static final class_2248 EXTERIOR_BLOCK = new ExteriorBlock(
            FabricBlockSettings.method_9637().method_22488().method_45477().method_9629(-1.0f, 3600000.0f).method_42327()
                    .method_50012(class_3619.field_15975).method_9631(ExteriorBlock.STATE_TO_LUMINANCE));

    @PickaxeMineable
    @NoEnglish
    public static final class_2248 DOOR_BLOCK = new DoorBlock(FabricBlockSettings.method_9637().method_22488().method_9634()
            .method_51368(class_2766.field_12653).method_29292().method_9629(0.5F, 6.0F).method_50012(class_3619.field_15975).method_9631(ExteriorBlock.STATE_TO_LUMINANCE));

    @NoBlockDrop
    @NoEnglish
    public static final class_2248 CONSOLE = new ConsoleBlock(
            FabricBlockSettings.method_9637().method_22488().method_45477().method_9629(-1.0f, 3600000.0f).method_42327()
                    .method_51368(class_2766.field_18285).method_50012(class_3619.field_15975));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @NoBlockDrop
    public static final class_2248 WAYPOINT_BANK = new WaypointBankBlock(
            FabricBlockSettings.method_9637().method_22488().method_29292().method_51368(class_2766.field_12653).method_9629(0.5F, 6.0F)
                    .method_50012(class_3619.field_15975).method_9631(light -> 3));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @NoEnglish
    public static final class_2248 LANDING_PAD = new LandingPadBlock(FabricBlockSettings.method_9637().method_29292()
            .method_51368(class_2766.field_12653).method_9629(0.5F, 6.0F).method_50012(class_3619.field_15975));

    @NoEnglish
    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    public static final class_2248 ENGINE_BLOCK = new EngineBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR)).method_29292()
            .method_51368(class_2766.field_12653).method_22488().method_9629(1.5F, 6.0F).method_50012(class_3619.field_15975));
    @PickaxeMineable
    public static final class_2248 CONSOLE_GENERATOR = new ConsoleGeneratorBlock(
            FabricBlockSettings.method_9637().method_22488().method_45477().method_29292().method_9632(1.5F)
                    .method_51368(class_2766.field_18285).method_50012(class_3619.field_15971));
    @PickaxeMineable
    @NoEnglish
    public static final class_2248 ARTRON_COLLECTOR_BLOCK = new ArtronCollectorBlock(
            FabricBlockSettings.method_9637().method_45477().method_29292().method_9632(1F)
                    .method_51368(class_2766.field_18288).method_50012(class_3619.field_15975));

    // Coral Blocks
    @NoEnglish
    public static final class_2248 CORAL_PLANT = new CoralPlantBlock(FabricBlockSettings.method_9637().method_9640().method_22488()
            .method_9634().method_9618().method_9626(class_2498.field_11535).method_50012(class_3619.field_15971));
    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    public static final class_2248 MATRIX_ENERGIZER = new MatrixEnergizerBlock(FabricBlockSettings.method_9637().method_9640().method_22488()
            .method_9631(light -> 0).method_51368(class_2766.field_18285)
            .method_9629(1.5F, 6.0F).method_29292().method_9626(class_2498.field_11531).method_50012(class_3619.field_15975));

    @PickaxeMineable(tool = PickaxeMineable.Tool.DIAMOND)
    public static final class_2248 TARDIS_CORAL_BLOCK = new class_2248(FabricBlockSettings.method_9637().method_31710(class_3620.field_15994).method_51369().method_51368(class_2766.field_12653).method_29292().method_9629(7f, 6.0f));

    @PickaxeMineable(tool = PickaxeMineable.Tool.DIAMOND)
    public static final class_2248 TARDIS_CORAL_STAIRS = new class_2510(TARDIS_CORAL_BLOCK.method_9564(), FabricBlockSettings.method_9637().method_31710(class_3620.field_15994).method_51369().method_51368(class_2766.field_12653).method_29292().method_9629(7f, 6.0f));

    @PickaxeMineable(tool = PickaxeMineable.Tool.DIAMOND)
    public static final class_2248 TARDIS_CORAL_SLAB = new class_2482(FabricBlockSettings.method_9637().method_31710(class_3620.field_15994).method_51369().method_51368(class_2766.field_12653).method_29292().method_9629(7f, 6.0f));

    @PickaxeMineable(tool = PickaxeMineable.Tool.DIAMOND)
    public static final class_2248 TARDIS_CORAL_FAN = new TardisCoralFanBlock(FabricBlockSettings.method_9637().method_31710(class_3620.field_15994).method_9634().method_9618().method_9626(class_2498.field_11534).method_50012(class_3619.field_15971).method_29292().method_9629(7f, 6.0f));

    @PickaxeMineable(tool = PickaxeMineable.Tool.DIAMOND)
    @NoBlockItem
    public static final class_2248 TARDIS_CORAL_WALL_FAN = new TardisCoralWallBlock(FabricBlockSettings.method_9637().method_31710(class_3620.field_15994).method_9634().method_9618().method_9626(class_2498.field_11534).method_50012(class_3619.field_15971).method_29292().method_9629(7f, 6.0f));


    // TARDIS Blocks

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    @NoEnglish
    public static final class_2248 MONITOR_BLOCK = new MonitorBlock(FabricBlockSettings.method_9637().method_22488().method_29292()
            .method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));
    @NoEnglish
    public static final class_2248 PLAQUE_BLOCK = new PlaqueBlock(
            FabricBlockSettings.method_9637().method_22488().method_45477().method_51368(class_2766.field_18285)
                    .method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));
    @NoEnglish
    public static final class_2248 WALL_MONITOR_BLOCK = new WallMonitorBlock(
            FabricBlockSettings.method_9637().method_22488().method_45477().method_51368(class_2766.field_18285)
                    .method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));
    @NoEnglish
    public static final class_2248 DETECTOR_BLOCK = new DetectorBlock(FabricBlockSettings.method_9637().method_22488()
            .method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F).method_50012(class_3619.field_15974));

    // Zeiton Blocks

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @NoEnglish
    public static final class_2248 ZEITON_BLOCK = new class_5541(FabricBlockSettings.method_9637().method_31710(class_3620.field_25706)
            .method_9629(1.5F, 6.0F).method_9626(class_2498.field_27197).method_29292());

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    public static final class_2248 BUDDING_ZEITON = new BuddingZeitonBlock(
            FabricBlockSettings.method_9637().method_31710(class_3620.field_25706).method_9640().method_9629(1.5F, 6.0F)
                    .method_9626(class_2498.field_27197).method_29292().method_50012(class_3619.field_15971));
    @NoBlockDrop
    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    public static final class_2248 ZEITON_CLUSTER = new class_5542(7, 3,
            FabricBlockSettings.method_9637().method_31710(class_3620.field_25706).method_51369().method_22488().method_9640()
                    .method_9626(class_2498.field_27198).method_9629(1.5F, 6.0F).method_9631((state) -> 5)
                    .method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    public static final class_2248 LARGE_ZEITON_BUD = new class_5542(5, 3,
            FabricBlockSettings.copyOf(ZEITON_CLUSTER).method_9626(class_2498.field_27200).method_51369()
                    .method_9631((state) -> 4).method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    public static final class_2248 MEDIUM_ZEITON_BUD = new class_5542(4, 3,
            FabricBlockSettings.copyOf(ZEITON_CLUSTER).method_9626(class_2498.field_27201).method_51369()
                    .method_9631((state) -> 2).method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    public static final class_2248 SMALL_ZEITON_BUD = new class_5542(3, 4,
            FabricBlockSettings.copyOf(ZEITON_CLUSTER).method_9626(class_2498.field_27199).method_51369()
                    .method_9631((state) -> 1).method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    @AutomaticModel
    public static final class_2248 COMPACT_ZEITON = new class_2248(FabricBlockSettings.copyOf(ZEITON_BLOCK));

    @PickaxeMineable(tool = PickaxeMineable.Tool.STONE)
    @AutomaticModel
    public static final class_2248 ZEITON_COBBLE = new class_2248(FabricBlockSettings.copyOf(ZEITON_BLOCK));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @AutomaticModel()
    public static final class_2248 POWER_CONVERTER = new PowerConverterBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR)).method_22488()
            .method_29292().method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @NoEnglish
    public static final class_2248 GENERIC_SUBSYSTEM = new GenericSubSystemBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR))
            .method_29292().method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    @NoEnglish
    public static final class_2248 FOOD_MACHINE = new FoodMachineBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.MAIN)).method_22488()
            .method_29292().method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));

    @NoBlockItem
    public static final class_2248 RADIO = new RadioBlock(FabricBlockSettings.method_9637().method_22488());

    // Machines
    @NoBlockItem
    public static final class_2248 MACHINE_CASING = new MachineCasingBlock(FabricBlockSettings.method_9637().method_22488()
            .method_29292().method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F));

    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    public static final class_2248 FABRICATOR = new FabricatorBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR)).method_22488()
            .method_29292().method_51368(class_2766.field_18285).method_9629(1.5F, 6.0F));

    @AutomaticModel(justItem = true)
    @PickaxeMineable(tool = PickaxeMineable.Tool.IRON)
    public static final class_2248 ASTRAL_MAP = new AstralMapBlock(FabricBlockSettings.method_9637().method_22488().method_9629(1.5F, 6.0F));

    // Control Blocks
    @NoBlockItem
    @NoEnglish
    public static final class_2248 REDSTONE_CONTROL_BLOCK = new RedstoneControlBlock(
            FabricBlockSettings.method_9637().method_22488().method_9629(1.5F, 6.0F).method_50012(class_3619.field_15971));

    public static final class_2248 ENVIRONMENT_PROJECTOR = new EnvironmentProjectorBlock(FabricBlockSettings.method_9637());

    // TODO ADVENT
    static {
        if (isUnlockedOnThisDay(Calendar.DECEMBER, 30)) {
            SNOW_GLOBE = new SnowGlobeBlock(FabricBlockSettings.method_9637().method_22488().method_51368(class_2766.field_12654).method_9629(1.5F, 6.0F));
        }
    }

    static {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register(entries -> {
            entries.addAfter(class_1802.field_27069, ZEITON_BLOCK);
            entries.addAfter(ZEITON_BLOCK, BUDDING_ZEITON);
            entries.addAfter(BUDDING_ZEITON, SMALL_ZEITON_BUD);
            entries.addAfter(SMALL_ZEITON_BUD, MEDIUM_ZEITON_BUD);
            entries.addAfter(MEDIUM_ZEITON_BUD, LARGE_ZEITON_BUD);
            entries.addAfter(LARGE_ZEITON_BUD, ZEITON_CLUSTER);
            entries.addAfter(ZEITON_CLUSTER, CHARGED_ZEITON_CRYSTAL);

            entries.addAfter(class_1802.field_33402, COMPACT_ZEITON);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(entries -> {
            entries.addAfter(class_1802.field_27063, ZEITON_SHARD);
            entries.addAfter(class_1802.field_8479, ZEITON_DUST);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(entries -> {
            entries.addAfter(class_1802.field_20412, ZEITON_COBBLE);
        });

    }

    @NoEnglish
    public static final class_2248 CABLE_BLOCK = new CableBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR)).method_22488()
            .method_51368(class_2766.field_12654).method_9629(1.5F, 6.0F));

    @NoEnglish

    public static final class_2248 CABLE_CONNECTOR_BLOCK = new FullCableBlock(ABlockSettings.method_9637()
            .itemSettings(new AItemSettings().group(AITItemGroups.FABRICATOR)).method_22488()
            .method_51368(class_2766.field_12654).method_9629(1.5F, 6.0F));


    public static List<class_2248> get() {
        List<class_2248> list = new ArrayList<>();

        for (class_2248 block : class_7923.field_41175) {
            if (class_7923.field_41175.method_10221(block).method_12836().equalsIgnoreCase(AITMod.MOD_ID)) {
                list.add(block);
            }
        }

        return list;
    }

    @Override
    public class_1792.class_1793 createBlockItemSettings(class_2248 block) {
        return new AItemSettings().group(AITItemGroups.MAIN);
    }
}
