package dev.amble.ait.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.util.NoEnglish;
import dev.amble.lib.item.AItemSettings;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1813;
import net.minecraft.class_1814;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.item.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.drinks.DrinkUtil;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.item.SubSystemItem;
import dev.amble.ait.core.item.*;
import dev.amble.ait.core.item.blueprint.BlueprintItem;
import dev.amble.ait.core.item.blueprint.BlueprintRegistry;
import dev.amble.ait.core.item.blueprint.BlueprintSchema;
import dev.amble.ait.core.item.control.GenericControlBlockItem;
import dev.amble.ait.core.item.link.AbstractLinkItem;
import dev.amble.ait.core.item.link.FluidLinkItem;
import dev.amble.ait.core.item.link.MercurialLinkItem;
import dev.amble.ait.core.item.part.MachinePartItem;

public class AITItems extends ItemContainer {

    @NoEnglish
    public static final class_1792 MUG = new DrinkItem(new AItemSettings().method_7889(1));
    public static final class_4174 ZEITON_DUST_FOOD = new class_4174.class_4175().method_19238(4).method_19237(0.3f)
            .method_19239(new class_1293(class_1294.field_5904, 1000, 3), 1.0F)
            .method_19239(new class_1293(AITStatusEffects.ZEITON_HIGH, 500, 1), 1.0F)
            .method_19239(new class_1293(class_1294.field_5920, 500, 1), 0.5F)
            .method_19239(new class_1293(class_1294.field_5916, 25, 1), 0.1F)
            .method_19239(new class_1293(class_1294.field_5903, 45, 1), 0.7F)
            .method_19239(new class_1293(class_1294.field_5901, 65, 1), 0.3F)
            .method_19242();

    // TARDIS
    @NoEnglish
    public static final class_1792 TARDIS_ITEM = new TardisItemBuilder(
            new AItemSettings().group(AITItemGroups.MAIN).method_24359().method_7889(1));

    @NoEnglish
    public static final LinkableItem SIEGE_ITEM = new SiegeTardisItem(new FabricItemSettings().method_24359());

    // Functional Items
    @NoEnglish
    public static final class_1792 REMOTE_ITEM = new RemoteItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1).method_24359().method_7898(300));
    @NoEnglish
    public static final class_1792 ARTRON_COLLECTOR = new ArtronCollectorItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1));
    public static final class_1792 RIFT_SCANNER = new RiftScannerItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1));
    public static final class_1792 GEIGER_COUNTER = new RiftScannerItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1));
    @NoEnglish
    public static final class_1792 HAMMER = new HammerItem(3, -2.4F,
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1).method_7895(600));
    public static final class_1792 RESPIRATOR = new RenderableArmorItem(class_1740.field_7892, class_1738.class_8051.field_41934,
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1).method_7895(80), true);
    public static final class_1792 FACELESS_RESPIRATOR = new RenderableArmorItem(class_1740.field_7892,
            class_1738.class_8051.field_41934, new AItemSettings().group(AITItemGroups.MAIN).method_7889(1).method_7895(80),
            true);

    public static final class_1792 SONIC_SCREWDRIVER = new SonicItem(new AItemSettings().method_7889(1).group(AITItemGroups.MAIN));

    public static final class_1792 HYPERCUBE = new HypercubeItem(new AItemSettings().method_7889(1).group(AITItemGroups.MAIN));
    public static final class_1792 PSYCHPAPER = new PsychpaperItem(new AItemSettings().method_7889(1).group(AITItemGroups.MAIN));
    public static final class_1792 HAZANDRA = new InteriorTeleporterItem(new AItemSettings().group(AITItemGroups.MAIN));

    // Keys/Horns - Templates
    public static final class_1792 IRON_KEY = new KeyItem(new AItemSettings().group(AITItemGroups.MAIN));
    public static final class_1792 GOLD_KEY = new KeyItem(
            new AItemSettings().method_7894(class_1814.field_8907).group(AITItemGroups.MAIN), KeyItem.Protocols.SNAP);
    public static final class_1792 NETHERITE_KEY = new KeyItem(
            new AItemSettings().method_7894(class_1814.field_8903).group(AITItemGroups.MAIN).method_24359(), KeyItem.Protocols.SNAP,
            KeyItem.Protocols.HAIL);
    public static final class_1792 CLASSIC_KEY = new KeyItem(
            new AItemSettings().method_7894(class_1814.field_8904).group(AITItemGroups.MAIN), KeyItem.Protocols.SNAP,
            KeyItem.Protocols.HAIL);

    // Creative only skeleton key
    public static final class_1792 SKELETON_KEY = new KeyItem(
            new AItemSettings().method_7894(class_1814.field_8904).group(AITItemGroups.MAIN), KeyItem.Protocols.SKELETON,
            KeyItem.Protocols.HAIL, KeyItem.Protocols.SNAP);

   /* public static final Item IRON_GOAT_HORN = new TardisGoatHorn(new AItemSettings().group(AITItemGroups.MAIN), InstrumentTags.GOAT_HORNS);

    public static final Item GOLD_GOAT_HORN = new TardisGoatHorn(new AItemSettings().rarity(Rarity.UNCOMMON).group(AITItemGroups.MAIN), InstrumentTags.GOAT_HORNS);

    public static final Item CLASSIC_GOAT_HORN = new TardisGoatHorn(new AItemSettings().rarity(Rarity.EPIC).group(AITItemGroups.MAIN), InstrumentTags.GOAT_HORNS, TardisGoatHorn.Protocols.HAIL);

    public static final Item NETHERITE_GOAT_HORN = new TardisGoatHorn(new AItemSettings().rarity(Rarity.RARE).group(AITItemGroups.MAIN), InstrumentTags.GOAT_HORNS, TardisGoatHorn.Protocols.HAIL);*/

    @NoEnglish
    public static final class_1792 GOLD_KEY_UPGRADE_SMITHING_TEMPLATE = new KeySmithingTemplateItem(
            new AItemSettings().group(AITItemGroups.MAIN), "Gold Key", "Gold Nugget");
    @NoEnglish
    public static final class_1792 NETHERITE_KEY_UPGRADE_SMITHING_TEMPLATE = new KeySmithingTemplateItem(
            new AItemSettings().group(AITItemGroups.MAIN), "Netherite Key", "Netherite Scrap");
    @NoEnglish
    public static final class_1792 CLASSIC_KEY_UPGRADE_SMITHING_TEMPLATE = new KeySmithingTemplateItem(
            new AItemSettings().group(AITItemGroups.MAIN), "Classic Key", "Amethyst Shard");


    // Crafting items
    public static final class_1792 ZEITON_SHARD = new ZeitonShardItem(new AItemSettings());
    public static final class_1792 CHARGED_ZEITON_CRYSTAL = new ChargedZeitonCrystalItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1));
    public static final class_1792 ZEITON_DUST = new class_1792(
            new AItemSettings().method_19265(ZEITON_DUST_FOOD));
    public static final class_1792 FOOD_CUBE = new class_1792(new AItemSettings().method_19265(AITFoodComponents.FOOD_CUBE));
    public static final class_1792 OVERCHARGED_FOOD_CUBE = new GlintItem(new AItemSettings().method_19265(AITFoodComponents.OVERCHARGED_FOOD_CUBE).method_7894(class_1814.field_8904));
    public static final class_1792 SUPERHEATED_ZEITON = new class_1792(new AItemSettings().group(AITItemGroups.MAIN));
    public static final class_1792 PLASMIC_MATERIAL = new class_1792(new AItemSettings().group(AITItemGroups.MAIN));
    public static final class_1792 CORAL_FRAGMENT = new class_1792(new AItemSettings().group(AITItemGroups.MAIN));
    public static final class_1792 CORAL_CAGE = new class_1792(new AItemSettings().group(AITItemGroups.MAIN));
    public static final class_1792 PERSONALITY_MATRIX = new PersonalityMatrixItem(new AItemSettings().group(AITItemGroups.MAIN));

    // Machine parts
    public static final class_1792 ARTRON_FLUID_LINK = new FluidLinkItem(AbstractLinkItem.Type.ARTRON,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 DATA_FLUID_LINK = new FluidLinkItem(AbstractLinkItem.Type.DATA,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 VORTEX_FLUID_LINK = new FluidLinkItem(AbstractLinkItem.Type.VORTEX,
            new AItemSettings().group(AITItemGroups.FABRICATOR));

    public static final class_1792 ARTRON_MERCURIAL_LINK = new MercurialLinkItem(AbstractLinkItem.Type.ARTRON,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 DATA_MERCURIAL_LINK = new MercurialLinkItem(AbstractLinkItem.Type.DATA,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 VORTEX_MERCURIAL_LINK = new MercurialLinkItem(AbstractLinkItem.Type.VORTEX,
            new AItemSettings().group(AITItemGroups.FABRICATOR));

    public static final class_1792 ORTHOGONAL_ENGINE_FILTER = new MachinePartItem(MachinePartItem.Type.ORTHOGONAL_ENGINE_FILTER,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 TRANSWARP_RESONATOR = new MachinePartItem(MachinePartItem.Type.TRANSWARP_RESONATOR,
            new AItemSettings().group(AITItemGroups.FABRICATOR));
    public static final class_1792 PHOTON_ACCELERATOR = new MachinePartItem(MachinePartItem.Type.PHOTON_ACCELERATOR,
            new AItemSettings() .group(AITItemGroups.FABRICATOR));
    public static final class_1792 HYPERION_CORE_SHAFT = new MachinePartItem(MachinePartItem.Type.HYPERION_CORE_SHAFT,
            new AItemSettings().group(AITItemGroups.FABRICATOR));

    // Components
    public static final class_1792 DEMATERIALIZATION_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.DEMAT);

    public static final class_1792 SHIELDS_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.SHIELDS);
    public static final class_1792 BACKUP_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.EMERGENCY_POWER);
    public static final class_1792 GRAVITATIONAL_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.GRAVITATIONAL);
    public static final class_1792 CHAMELEON_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.CHAMELEON);
    public static final class_1792 DESPERATION_CIRCUIT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.DESPERATION);
    public static final class_1792 STABILISERS = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.STABILISERS);
    public static final class_1792 LIFE_SUPPORT = new SubSystemItem(
            new AItemSettings().group(AITItemGroups.FABRICATOR), SubSystem.Id.LIFE_SUPPORT);

    @NoEnglish
    public static final class_1792 GALLIFREY_FALLS_PAINTING = new AITDecorationItem(AITEntityTypes.GALLIFREY_FALLS_PAINTING_ENTITY_TYPE,
            new AItemSettings().group(AITItemGroups.MAIN));
    @NoEnglish
    public static final class_1792 TRENZALORE_PAINTING = new AITDecorationItem(AITEntityTypes.TRENZALORE_PAINTING_ENTITY_TYPE,
            new AItemSettings().group(AITItemGroups.MAIN));

    // Blueprint
    public static final class_1792 BLUEPRINT = new BlueprintItem(
            new AItemSettings().method_7894(class_1814.field_8904));

    // Waypoint-related
    public static final class_1792 WAYPOINT_CARTRIDGE = new WaypointItem(
            new AItemSettings().group(AITItemGroups.MAIN).method_7889(1));

    // Music discs
    @NoEnglish
    public static final class_1792 DRIFTING_MUSIC_DISC = new class_1813(1, AITSounds.DRIFTING_MUSIC,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 169);

    @NoEnglish
    public static final class_1792 WONDERFUL_TIME_IN_SPACE_MUSIC_DISC = new class_1813(1, AITSounds.WONDERFUL_TIME_IN_SPACE,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 73);


    @NoEnglish
    public static final class_1792 VENUS_MUSIC_DISC = new class_1813(1, AITSounds.VENUS_MUSIC,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 342);

    @NoEnglish
    public static final class_1792 GOOD_MAN_MUSIC_DISC = new class_1813(1, AITSounds.GOOD_MAN_MUSIC,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 342);

    @NoEnglish
    public static final class_1792 CHRONOLOGY_MUSIC_DISC = new class_1813(1, AITSounds.CHRONOLOGY_MUSIC,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 180);

    @NoEnglish
    public static final class_1792 EARTH_MUSIC_DISC = new class_1813(1, AITSounds.EARTH_MUSIC,
            new AItemSettings().method_7889(1).method_7894(class_1814.field_8903), 315);


    // Block controls

     public static final class_1792 REDSTONE_CONTROL = new
             GenericControlBlockItem(AITBlocks.REDSTONE_CONTROL_BLOCK, new
     AItemSettings().group(AITItemGroups.MAIN));
    public static boolean isUnlockedOnThisDay(int month, int day) {
        return getAdventDates(month, Calendar.JANUARY, day, 6);
    }

    private static void addDrinks(FabricItemGroupEntries entries) {
        DrinkRegistry.getInstance().toList().stream()/*.filter(entry -> entry != DrinkRegistry.EMPTY_MUG)*/
                .map(entry -> DrinkUtil.setDrink(new class_1799(AITItems.MUG),
                        entry)).forEach(stack -> entries.method_45417(stack, class_1761.class_7705.field_40191));
    }

    public static boolean getAdventDates(int monthBegin, int monthEnd, int dayBegin, int dayEnd) {
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(Calendar.MONTH);
        int currentDay = calendar.get(Calendar.DAY_OF_MONTH);

        // Handle the case where the date range spans across two years
        if (monthBegin == Calendar.DECEMBER && monthEnd == Calendar.JANUARY) {
            return (currentMonth == Calendar.DECEMBER && currentDay >= dayBegin) || (currentMonth == Calendar.JANUARY && currentDay <= dayEnd);
        } else {
            return currentMonth >= monthBegin && currentMonth <= monthEnd && currentDay >= dayBegin && currentDay <= dayEnd;
        }
    }

    public static boolean isInAdvent() {
        return getAdventDates(Calendar.DECEMBER, Calendar.JANUARY, 26, 6);
    }

    public static List<class_1792> get() {
        List<class_1792> list = new ArrayList<>();

        for (class_1792 item : class_7923.field_41178) {
            if (class_7923.field_41178.method_10221(item).method_12836().equalsIgnoreCase(AITMod.MOD_ID)) {
                list.add(item);
            }
        }

        return list;
    }

    static {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(entries -> {
            entries.addAfter(class_1802.field_44705, DRIFTING_MUSIC_DISC);
            entries.addAfter(DRIFTING_MUSIC_DISC, WONDERFUL_TIME_IN_SPACE_MUSIC_DISC);
            entries.addAfter(WONDERFUL_TIME_IN_SPACE_MUSIC_DISC, EARTH_MUSIC_DISC);
            entries.addAfter(EARTH_MUSIC_DISC, VENUS_MUSIC_DISC, GOOD_MAN_MUSIC_DISC, CHRONOLOGY_MUSIC_DISC);
        });



        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(entries -> {
            addDrinks(entries);
            entries.addAfter(class_1802.field_8680, FOOD_CUBE);
        });

        /*ItemGroupEvents.modifyEntriesEvent(ItemGroups.TOOLS).register(entries -> {
            entries.addAfter(Items.BUCKET);
        });*/

        ItemGroupEvents.modifyEntriesEvent(class_5321.method_29179(class_7924.field_44688, AITItemGroups.FABRICATOR.id())).register(entries -> {
            for (BlueprintSchema schema : BlueprintRegistry.getInstance().toList()) {
                entries.method_45420(BlueprintItem.createStack(schema));
            }
        });
    }
}
