package dev.amble.ait.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.bind.KeyBind;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.Tardis;

public class AITKeyBinds {

    private static final List<KeyBind> BINDS = new ArrayList<>();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (KeyBind bind : BINDS)
                bind.tick(client);
        });

        register(new KeyBind.Held("snap", "main", class_3675.class_307.field_1668, GLFW.GLFW_KEY_V, client -> {
            class_746 player = client.field_1724;

            if (player == null)
                return;

            if (player.method_5765()) {
                class_1297 entity = player.method_5854();
                if (entity instanceof FlightTardisEntity flightTardis) {
                    if (!flightTardis.isLinked()) return;
                    Tardis tardis = flightTardis.tardis().get();

                    ClientTardisUtil.snapToOpenDoors(tardis);
                    return;
                }
            }

            Collection<class_1799> keys = KeyItem.getKeysInInventory(player);

            for (class_1799 stack : keys) {
                if (stack.method_7909() instanceof KeyItem key && key.hasProtocol(KeyItem.Protocols.SNAP)) {
                    Tardis tardis = key.getTardis(player.method_37908(), stack);

                    if (tardis == null)
                        return;

                    ClientTardisUtil.snapToOpenDoors(tardis);
                }
            }
        }));
        register(new KeyBind.Held("increase_speed", "main", class_3675.class_307.field_1668, GLFW.GLFW_KEY_G, client -> {
            class_746 player = client.field_1724;

            if (player == null || !player.method_5765())
                return;

            class_1297 entity = player.method_5854();
            if (entity instanceof FlightTardisEntity flightTardis) {
                if (!flightTardis.isLinked()) return;
                Tardis tardis = flightTardis.tardis().get();

                ClientTardisUtil.flyingSpeedPacket(tardis, "up");
            }
        }));
        register(new KeyBind.Held("decrease_speed", "main", class_3675.class_307.field_1668, GLFW.GLFW_KEY_B, client -> {
            class_746 player = client.field_1724;

            if (player == null || !player.method_5765())
                return;

            class_1297 entity = player.method_5854();
            if (entity instanceof FlightTardisEntity flightTardis) {
                if (!flightTardis.isLinked()) return;
                Tardis tardis = flightTardis.tardis().get();

                ClientTardisUtil.flyingSpeedPacket(tardis, "down");
            }
        }));
        register(new KeyBind.Held("toggle_antigravs", "main", class_3675.class_307.field_1668, GLFW.GLFW_KEY_H, client -> {
            class_746 player = client.field_1724;

            if (player == null || !player.method_5765())
                return;

            class_1297 entity = player.method_5854();
            if (entity instanceof FlightTardisEntity flightTardis) {
                if (!flightTardis.isLinked()) return;
                Tardis tardis = flightTardis.tardis().get();

                ClientTardisUtil.toggleAntigravs(tardis);
            }
        }));
    }

    private static void register(KeyBind bind) {
        bind.register();
        BINDS.add(bind);
    }
}
