package dev.amble.ait.core.advancement;

import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_161;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.effects.ZeitonHighEffect;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.world.TardisServerWorld;

public class TardisCriterions {
    public static SimpleCriterion ROOT = SimpleCriterion.create("root").register();
    public static SimpleCriterion TAKEOFF = SimpleCriterion.create("takeoff").register();
    public static SimpleCriterion CRASH = SimpleCriterion.create("crash").register();
    public static SimpleCriterion VEGETATION = SimpleCriterion.create("break_vegetation").register();
    public static SimpleCriterion PLACE_CORAL = SimpleCriterion.create("place_coral").register();
    public static final SimpleCriterion PLACE_ENERGIZER = SimpleCriterion.create("place_energizer").register();
    public static SimpleCriterion FEED_POWER_CONVERTER = SimpleCriterion.create("feed_power_converter").register();
    public static SimpleCriterion ENTER_TARDIS = SimpleCriterion.create("enter_tardis").register();
    public static SimpleCriterion REDECORATE = SimpleCriterion.create("redecorate").register();
    public static SimpleCriterion FORCED_ENTRY = SimpleCriterion.create("forced_entry").register();
    public static SimpleCriterion SONIC_WOOD = SimpleCriterion.create("sonic_wood").register();
    public static SimpleCriterion PILOT_HIGH = SimpleCriterion.create("pilot_high").register();
    public static SimpleCriterion REACH_PILOT = SimpleCriterion.create("reach_pilot").register();
    public static SimpleCriterion REACH_OWNER = SimpleCriterion.create("reach_owner").register();
    public static SimpleCriterion ENABLE_SUBSYSTEM = SimpleCriterion.create("enable_subsystem").register();
    public static SimpleCriterion REPAIR_SUBSYSTEM = SimpleCriterion.create("repair_subsystem").register();
    public static SimpleCriterion ENGINES_PHASE = SimpleCriterion.create("engines_phase").register();
    public static SimpleCriterion BRAND_NEW = SimpleCriterion.create("brand_new").register();
    public static SimpleCriterion ATTACK_EYEBROWS = SimpleCriterion.create("attack_eyebrows").register();
    public static SimpleCriterion FIRST_RIFT = SimpleCriterion.create("first_rift").register();

    public static void init() {
        AITMod.LOGGER.info("Initializing Tardis Criterions");

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ROOT.trigger(handler.method_32311()));

        TardisEvents.CRASH.register(tardis -> tardis.asServer().world().method_18456().forEach(
                player -> TardisCriterions.CRASH.trigger(player)));

        TardisEvents.ENTER_FLIGHT.register(tardis -> {
            tardis.asServer().world().method_18456().forEach(player -> {
                TardisCriterions.TAKEOFF.trigger(player);

                if (ZeitonHighEffect.isHigh(player))
                    TardisCriterions.PILOT_HIGH.trigger(player);
            });
        });

        TardisEvents.ENTER_TARDIS.register((tardis, entity) -> {
            if (!(entity instanceof class_3222 player))
                return;

            class_161 advancement = player.method_5682().method_3851().method_12896(new class_2960("ait/enter_tardis"));

            if (player.method_37908() instanceof TardisServerWorld && !player.method_14236().method_12882(advancement).method_740()) {
                Scheduler.get().runTaskLater(() -> tardis.asServer().world().method_8396(null, player.method_24515(), AITSounds.WONDERFUL_TIME_IN_SPACE,
                        class_3419.field_15248, 0.6f, 1.0f), TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 400);
            }

            TardisCriterions.ENTER_TARDIS.trigger(player);
        });

        TardisEvents.FORCED_ENTRY.register((tardis, entity) -> {
            if (!(entity instanceof class_3222 player))
                return;

            TardisCriterions.FORCED_ENTRY.trigger(player);
        });

        TardisEvents.SUBSYSTEM_ENABLE.register(system -> {
            if (system.isClient() || system instanceof EngineSystem)
                return;

            system.tardis().asServer().world().method_18456().forEach(player ->
                    TardisCriterions.ENGINES_PHASE.trigger(player));
        });
        TardisEvents.SUBSYSTEM_REPAIR.register(system -> {
            if (system.isClient())
                return;

            system.tardis().asServer().world().method_18456().forEach(player ->
                    TardisCriterions.REPAIR_SUBSYSTEM.trigger(player));
        });

        TardisEvents.ENGINES_PHASE.register(system -> {
            if (system.isClient())
                return;

            system.tardis().asServer().world().method_18456().forEach(player ->
                    TardisCriterions.REACH_PILOT.trigger(player));
        });
    }
}
