package dev.amble.ait.core.bind;

import java.util.function.Consumer;

import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import dev.amble.ait.AITMod;

public class KeyBind {

    protected final String name;
    protected final String category;

    protected final class_3675.class_307 type;
    protected final int code;

    protected class_304 self;
    private final Consumer<class_310> consumer;

    public KeyBind(String name, String category, class_3675.class_307 type, int code, Consumer<class_310> consumer) {
        this.name = name;
        this.category = category;

        this.type = type;
        this.code = code;

        this.consumer = consumer;
    }

    public void tick(class_310 client) {
        if (this.shouldTrigger(client))
            this.trigger(client);
    }

    public void register() {
        this.self = KeyBindingHelper.registerKeyBinding(new class_304("key." + AITMod.MOD_ID + "." + name, this.type,
                this.code, "category." + AITMod.MOD_ID + "." + category));
    }

    protected boolean shouldTrigger(class_310 client) {
        return this.self.method_1434();
    }

    protected void trigger(class_310 client) {
        this.consumer.accept(client);
    }

    public static class Held extends KeyBind {

        private boolean held;

        public Held(String name, String category, class_3675.class_307 type, int code, Consumer<class_310> consumer) {
            super(name, category, type, code, consumer);
        }

        @Override
        protected boolean shouldTrigger(class_310 client) {
            class_746 player = client.field_1724;

            if (player == null)
                return false;

            if (!this.self.method_1434()) {
                this.held = false;
                return false;
            }

            if (this.held)
                return false;

            this.held = true;
            return true;
        }
    }
}
