package dev.amble.ait.core.blockentities;

import static dev.amble.ait.core.blocks.RadioBlock.*;
import static java.lang.Double.NaN;

import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import dev.amble.ait.core.AITBlockEntityTypes;

public class AITRadioBlockEntity extends class_2586 {

    public class_1657 player;
    public float tickRotT, tickRotV;

    private int timeInSeconds;

    public AITRadioBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.AIT_RADIO_BLOCK_ENTITY_TYPE, pos, state);
        setTickRot("tuner", 0);
        setTickRot("volume", 0);
        toggleRadio(true);
    }

    public static void tick(class_1937 world1, class_2338 pos, class_2680 state, AITRadioBlockEntity be) {
        be.timeInSeconds++;
        if (be.getTickRot("volume") > 0 && be.hasSecondPassed()) {
            be.timeInSeconds = 0;
            be.spawnNoteParticle(world1, pos);
        }
    }

    public boolean hasSecondPassed() {
        return this.timeInSeconds >= 20;
    }

    private void spawnNoteParticle(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218 serverWorld) {
            class_243 vec3d = class_243.method_24955(pos).method_1031(0.0, 1.2f, 0.0);
            serverWorld.method_14199(class_2398.field_11224, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0, NaN, 0.0, 0.0,
                    1.0F);
        }
    }

    public void useOn(class_3965 hit, class_2680 state, class_1657 player, class_1937 world, boolean isSneaking) {
        this.player = player;
        double mouseX = (hit.method_17784().field_1352 * 16) - (hit.method_17777().method_10263() * 16);
        double mouseY = (hit.method_17784().field_1351 * 16) - (hit.method_17777().method_10264() * 16);
        double mouseZ = (hit.method_17784().field_1350 * 16) - (hit.method_17777().method_10260() * 16);

        double[] xTuner = {0, 0, PZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11048), NZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11048),
                PX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11048), NX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11048)};
        double[] yTuner = {0, 0, PZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11052), NZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11052),
                PX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11052), NX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11052)};
        double[] zTuner = {0, 0, PZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11051), NZ_AXIS_TUNER.method_1091(class_2350.class_2351.field_11051),
                PX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11051), NX_AXIS_TUNER.method_1091(class_2350.class_2351.field_11051)};

        double[] xVolume = {0, 0, PZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11048), NZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11048),
                PX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11048), NX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11048)};
        double[] yVolume = {0, 0, PZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11052), NZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11052),
                PX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11052), NX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11052)};
        double[] zVolume = {0, 0, PZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11051), NZ_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11051),
                PX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11051), NX_AXIS_VOLUME.method_1091(class_2350.class_2351.field_11051)};

        double width = 2;
        double height = 2;
        double length = 2;
        float multiVal = 36; // 22.5;

        boolean tmx = mouseX >= (xTuner[state.method_11654(FACING).ordinal()] * 16)
                && mouseY >= (yTuner[state.method_11654(FACING).ordinal()] * 16)
                && mouseZ >= (zTuner[state.method_11654(FACING).ordinal()] * 16)
                && mouseX <= ((xTuner[state.method_11654(FACING).ordinal()] * 16) + width)
                && mouseY <= ((yTuner[state.method_11654(FACING).ordinal()] * 16) + height)
                && mouseZ <= ((zTuner[state.method_11654(FACING).ordinal()] * 16) + length);

        boolean vmx = mouseX >= (xVolume[state.method_11654(FACING).ordinal()] * 16)
                && mouseY >= (yVolume[state.method_11654(FACING).ordinal()] * 16)
                && mouseZ >= (zVolume[state.method_11654(FACING).ordinal()] * 16)
                && mouseX <= ((xVolume[state.method_11654(FACING).ordinal()] * 16) + width)
                && mouseY <= ((yVolume[state.method_11654(FACING).ordinal()] * 16) + height)
                && mouseZ <= ((zVolume[state.method_11654(FACING).ordinal()] * 16) + length);

        if (tmx && this.isRadioOn() && !isSneaking) {
            if (this.tickRotT < (360F - 22.5F) * ((float) Math.PI / 180f))
                this.tickRotT = this.tickRotT + 22.5F * ((float) Math.PI / 180f);
            else if (this.tickRotT >= (360F - 22.5F) * ((float) Math.PI / 180f))
                this.tickRotT = 0;
            //System.out.println(this.tickRotT + " ?=? " + 360F * ((float) Math.PI / 180f));
            if (player != null)
                player.method_7353(class_2561.method_43470("Changing Frequency..."), true);
            world.method_8396(null, field_11867, class_3417.field_15015.comp_349(), class_3419.field_15250, 0.1F,
                    this.tickRotT * this.tickRotT);
        }
        if (vmx && this.isRadioOn() && !isSneaking) {
            if (this.tickRotV <= (360F - multiVal) * ((float) Math.PI / 180f))
                this.tickRotV = this.tickRotV + multiVal * ((float) Math.PI / 180f);
            else if (this.tickRotV <= 360F * ((float) Math.PI / 180f))
                this.tickRotV = 0;

            world.method_8396(null, field_11867, class_3417.field_15015.comp_349(), class_3419.field_15250, 0.1F,
                    this.tickRotV * this.tickRotV);
        }

        if (!isSneaking && tmx && this.isRadioOn())
            this.setTickRot("tuner", this.tickRotT);

        if (!isSneaking && vmx && this.isRadioOn())
            this.setTickRot("volume", this.tickRotV);

        // @TODO Use SoundInstance and Minecraft.getInstance().getSoundManager() to play
        // music. It
        // allows for multiple
        // values like looping and stopping the audio. It's perfect for our use case. -
        // Loqor
        // @Creativious
        if (((int) (Math.nextUp(this.getTickRot("volume") * (180 / Math.PI) * 11) / 360) + 1) == 10) {
            // world.playSound(null, pos, AITSounds.SECRET_MUSIC, SoundCategory.MASTER, 1F, 1F);
        }

        if (this.isRadioOn()) {
            if (isSneaking && !vmx && !tmx) {
                this.toggleRadio(!this.isRadioOn());
                if (player != null)
                    player.method_7353(class_2561.method_43470("Radio Off"), true);
                world.method_8396(null, field_11867, class_3417.field_24062, class_3419.field_15250, 0.2F, 1F);
            }
        } else {
            this.toggleRadio(!this.isRadioOn());
            if (player != null)
                player.method_7353(class_2561.method_43470("Radio On"), true);
            world.method_8396(null, field_11867, class_3417.field_24062, class_3419.field_15250, 0.2F, 2F);
        }
    }

    public float getTickRot(String name) {
        return switch (name) {
            case "tuner" -> tickRotT;
            case "volume" -> tickRotV;
            default -> throw new IllegalArgumentException("Unexpected value: " + name);
        };
    }

    public boolean isRadioOn() {
        return true;
    }

    public void setTickRot(String name, float value) {
        if (name.equals("tuner"))
            this.tickRotT = value;
        else if (name.equals("volume"))
            this.tickRotV = value;
    }

    public void toggleRadio(boolean bool) {
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
    }

    record Handle(Function<class_2350, class_265> shape) {

        public boolean check(class_3965 hit, class_2680 state) {
            double mouseX = (hit.method_17784().field_1352 * 16) - (hit.method_17777().method_10263() * 16);
            double mouseY = (hit.method_17784().field_1351 * 16) - (hit.method_17777().method_10264() * 16);
            double mouseZ = (hit.method_17784().field_1350 * 16) - (hit.method_17777().method_10260() * 16);

            class_265 s = shape.apply(state.method_11654(FACING));

            double minX = s.method_1091(class_2350.class_2351.field_11048);
            double maxX = s.method_1105(class_2350.class_2351.field_11048);
            double minY = s.method_1091(class_2350.class_2351.field_11052);
            double maxY = s.method_1105(class_2350.class_2351.field_11052);
            double minZ = s.method_1091(class_2350.class_2351.field_11051);
            double maxZ = s.method_1105(class_2350.class_2351.field_11051);

            // DOWN: >= 0 <= 0 + 2
            // UP: >= 16 <= 18
            //
            boolean checkX = mouseX >= (minX * 16) && mouseX <= (maxX * 16);

            boolean checkY = mouseY >= (minY * 16) && mouseY <= (maxY * 16);

            boolean checkZ = mouseZ >= (minZ * 16) && mouseZ <= (maxZ * 16);

            return checkX && checkY && checkZ;
        }
    }
}
