package dev.amble.ait.core.blockentities;

import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.ArtronHolder;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.item.ArtronCollectorItem;
import dev.amble.ait.core.item.ChargedZeitonCrystalItem;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.module.gun.core.item.StaserBoltMagazine;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5558;

public class ArtronCollectorBlockEntity extends class_2586 implements class_5558<ArtronCollectorBlockEntity>, ArtronHolder {

    public double artronAmount = 0;

    public ArtronCollectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.ARTRON_COLLECTOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("artronAmount", this.artronAmount);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545("artronAmount"))
            this.setCurrentFuel(nbt.method_10574("artronAmount"));
        super.method_11014(nbt);
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (!world.method_8608()) {
            player.method_43496(class_2561.method_43470(this.getCurrentFuel() + "/" + ArtronCollectorItem.COLLECTOR_MAX_FUEL)
                    .method_27692(class_124.field_1065));
            class_1799 stack = player.method_6047();
            if (stack.method_7909() instanceof ArtronCollectorItem) {
                double residual = ArtronCollectorItem.addFuel(stack, this.getCurrentFuel());
                this.setCurrentFuel(residual);
            } else if (stack.method_7909() instanceof ArtronHolderItem) {
                double residual = ((ArtronHolderItem) stack.method_7909()).addFuel(this.getCurrentFuel(), stack);
                this.setCurrentFuel(residual);
            } else if (stack.method_7909() instanceof ChargedZeitonCrystalItem crystal) {
                double residual = crystal.addFuel(this.getCurrentFuel(), stack);
                this.setCurrentFuel(residual);
            } else if (stack.method_7909() instanceof StaserBoltMagazine magazine) {
                double residual = magazine.addFuel(this.getCurrentFuel(), stack);
                this.setCurrentFuel(residual);
            }
            if (stack.method_31574(AITBlocks.ZEITON_CLUSTER.method_8389())) {
                if (sneaking) {
                    player.method_31548().method_5447(player.method_31548().field_7545,
                            new class_1799(AITItems.CHARGED_ZEITON_CRYSTAL));
                    return;
                }

                // todo - instead of zeiton cluster for fuel, check for the TARDIS_FUEL tag
                this.addFuel(15);
                stack.method_7934(1);
            }
        }
    }

    @Override
    public void setCurrentFuel(double artronAmount) {
        this.artronAmount = artronAmount;
        this.updateListeners(this.method_11010());
    }

    @Override
    public double getMaxFuel() {
        return ArtronCollectorItem.COLLECTOR_MAX_FUEL;
    }

    @Override
    public double getCurrentFuel() {
        return this.artronAmount;
    }

    @Nullable @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbtCompound = super.method_16887();
        nbtCompound.method_10549("artronAmount", this.artronAmount);
        return nbtCompound;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, ArtronCollectorBlockEntity blockEntity) {
        if (world.method_8608())
            return;

        if (world.method_8503().method_3780() % 3 == 0)
            return;

        RiftChunkManager manager = RiftChunkManager.getInstance((class_3218) this.field_11863);
        class_1923 chunk = new class_1923(pos);

        if (shouldDrain(manager, chunk)) {
            manager.removeFuel(chunk, 3);
            this.addFuel(3);

            this.updateListeners(state);
        }
    }

    private boolean shouldDrain(RiftChunkManager manager, class_1923 pos) {
        return this.getCurrentFuel() < ArtronCollectorItem.COLLECTOR_MAX_FUEL
                && manager.getArtron(pos) >= 3;
    }

    private void updateListeners(class_2680 state) {
        this.method_5431();

        if (!this.method_11002())
            return;

        this.field_11863.method_8413(this.method_11016(), this.method_11010(), state, class_2248.field_31036);
    }
}
