package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.blocks.DoorBlock;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_7718;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;

public class DoorBlockEntity extends InteriorLinkableBlockEntity {

    private DirectedBlockPos directedPos;

    public DoorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.DOOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 blockState, T tDoor) {
        DoorBlockEntity door = (DoorBlockEntity) tDoor;

        if (!(world instanceof class_3218 serverWorld))
            return;

        if (!door.isLinked())
            return;

        Tardis tardis = door.tardis().get();

        if (world.method_8503().method_3780() % 5 != 0)
            return;

        CachedDirectedGlobalPos globalExteriorPos = tardis.travel().position();

        if (globalExteriorPos == null)
            return;

        class_2338 exteriorPos = globalExteriorPos.getPos();
        class_1937 exteriorWorld = globalExteriorPos.getWorld();

        if (exteriorWorld == null)
            return;

        blockState = blockState.method_11657(DoorBlock.LEVEL_4, exteriorWorld.method_22339(exteriorPos.method_10084()));

        // exit early for light updates
        if (world.method_8503().method_3780() % 20 != 0) {
            world.method_8652(pos, blockState, class_2248.field_31036 | class_2248.field_31030);
            return;
        }

        if (!tardis.door().isOpen() || tardis.areShieldsActive()) {
            world.method_8652(pos, blockState.method_11657(class_2741.field_12508, false),
                class_2248.field_31036 | class_2248.field_31030);
            return;
        }

        if (blockState.method_11654(class_2741.field_12508) && world.method_8409().method_43056()) {
            serverWorld.method_18456().forEach(player -> tardis.loyalty().subLevel(player, 2));
        }

        class_1923 exteriorChunkPos = new class_1923(exteriorPos);
        class_2791 exteriorChunk = exteriorWorld.method_8402(exteriorChunkPos.field_9181, exteriorChunkPos.field_9180, class_2806.field_12798, false);

        if (exteriorChunk == null)
            return;

        class_2680 exteriorState = exteriorChunk.method_8320(exteriorPos);

        if (!(exteriorState.method_26204() instanceof ExteriorBlock))
            return;

        // TODO: performance sink. this should ideally be done in the exterior block code...
        boolean waterlogged = exteriorWorld.method_8320(exteriorPos).method_11654(class_2741.field_12508);

        world.method_8652(pos, blockState.method_11657(class_2741.field_12508, waterlogged),
                class_2248.field_31036 | class_2248.field_31030);

        world.method_33596(null, class_5712.field_28733, pos);
        world.method_39281(pos, blockState.method_26227().method_15772(),
                blockState.method_26227().method_15772().method_15789(world));
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (player == null || this.tardis() == null || this.tardis().isEmpty())
            return;

        Tardis tardis = this.tardis().get();
        class_1799 keyStack = player.method_6047();

        if (tardis.hasGrowthExterior())
            return;

        tardis.getDesktop().setDoorPos(this);

        if (keyStack.method_7909() instanceof KeyItem key && !tardis.siege().isActive()) {
            if (keyStack.method_31574(AITItems.SKELETON_KEY) || key.isOf(keyStack, tardis)) {
                tardis.door().interactToggleLock((class_3222) player);
            } else {
                world.method_8396(null, field_11867, class_3417.field_18311.comp_349(), class_3419.field_15245, 1F, 0.2F);
                player.method_7353(class_2561.method_43471("tardis.key.identity_error"), true); // TARDIS does not identify with key
            }

            return;
        }

        if (tardis.sonic().getExteriorSonic() != null) {
            SonicHandler handler = tardis.sonic();
            if (field_11867 != null) {
                player.method_31548().method_7398(handler.takeExteriorSonic());
                world.method_8396(null, field_11867, class_3417.field_23117.comp_349(), class_3419.field_15245, 1F,
                        0.2F);
            }

            return;
        }

        tardis.door().interact((class_3218) world, this.method_11016(), (class_3222) player);
    }

    public class_2350 getFacing() {
        return this.method_11010().method_11654(HorizontalDirectionalBlock.FACING);
    }

    @Nullable @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public void onEntityCollision(class_1297 entity) {
        if (!TardisServerWorld.isTardisDimension((class_3218) this.method_10997()))
            return;

        if (!this.isLinked())
            return;

        Tardis tardis = this.tardis().get();

        if (tardis.door().isClosed())
            return;

        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && tardis.getExterior().getVariant().hasPortals())
            return;

        TravelHandler travel = tardis.travel();

        if (!tardis.flight().isFlying() && travel.getState() == TravelHandlerBase.State.FLIGHT && !tardis.areShieldsActive()) {
            TardisUtil.dropOutside(tardis, entity);
            return;
        }

        if (travel.getState() != TravelHandlerBase.State.LANDED)
            return;

        TardisUtil.teleportOutside(tardis, entity);
    }

    @Override
    public void onLinked() {
        this.tardis().ifPresent(tardis -> tardis.getDesktop().setDoorPos(this));
    }

    public void onBreak() {
        if (!this.isLinked())
            return;

        Tardis tardis = this.tardis().get();
        tardis.door().closeDoors();

        tardis.getDesktop().removeDoor(this);
    }

    public DirectedBlockPos getDirectedPos() {
        if (this.directedPos != null)
            return this.directedPos;

        this.directedPos = DirectedBlockPos.create(this.method_11016(), (byte)
                class_7718.method_45481(this.getFacing()));

        return this.directedPos;
    }
}
