package dev.amble.ait.core.blockentities;

import static dev.amble.ait.core.blocks.EnvironmentProjectorBlock.*;

import java.util.Iterator;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blocks.EnvironmentProjectorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.properties.Value;

public class EnvironmentProjectorBlockEntity extends InteriorLinkableBlockEntity {

    private static final class_5321<class_1937> DEFAULT = class_1937.field_25181;
    private class_5321<class_1937> current = DEFAULT;

    public EnvironmentProjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.ENVIRONMENT_PROJECTOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        boolean powered = world.method_49803(pos);

        if (powered != state.method_11654(POWERED)) {
            if (state.method_11654(ENABLED) != powered) {
                state = state.method_11657(ENABLED, powered);

                EnvironmentProjectorBlock.toggle(this.tardis().get(), null, world, pos, state, powered);
            }

            state = state.method_11657(POWERED, powered);
        }

        world.method_8652(pos, state.method_11657(SILENT, world.method_8320(pos.method_10074()).method_26164(class_3481.field_15481)),
                class_2248.field_31028);
    }

    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!this.isLinked())
            return class_1269.field_5814;

        Tardis tardis = this.tardis().get();

        if (player.method_5715()) {
            this.switchSkybox(tardis, state, player);
            return class_1269.field_5812;
        }

        state = state.method_28493(ENABLED);
        world.method_8652(pos, state, class_2248.field_31028);

        EnvironmentProjectorBlock.toggle(tardis, null, world, pos, state, state.method_11654(ENABLED));
        return class_1269.field_5812;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);

        this.current = class_5321.method_29179(class_7924.field_41223, new class_2960(nbt.method_10558("dimension")));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        nbt.method_10582("dimension", this.current.method_29177().toString());
    }

    public void switchSkybox(Tardis tardis, class_2680 state, class_1657 player) {
        class_3218 next = findNext(this.current);

        while (TardisServerWorld.isTardisDimension(next)) {
            next = findNext(next.method_27983());
        }

        player.method_43496(class_2561.method_43469("message.ait.projector.skybox", next.method_27983().method_29177().toString()));
        AITMod.LOGGER.debug("Last: {}, next: {}", this.current, next);

        this.current = next.method_27983();

        if (state.method_11654(EnvironmentProjectorBlock.ENABLED))
            this.apply(tardis, state);
    }

    public void toggle(Tardis tardis, class_2680 state, boolean active) {
        if (active) {
            this.apply(tardis, state);
        } else {
            this.disable(tardis);
        }
    }

    public void apply(Tardis tardis, class_2680 state) {
        tardis.stats().skybox().set(this.current);
        tardis.stats().skyboxDirection().set(state.method_11654(EnvironmentProjectorBlock.FACING));
    }

    public void disable(Tardis tardis) {
        Value<class_5321<class_1937>> value = tardis.stats().skybox();

        if (same(this.current, value.get()))
            value.set(DEFAULT);
    }

    private static class_3218 findNext(class_5321<class_1937> last) {
        Iterator<class_3218> iter = WorldUtil.getProjectorWorlds().iterator();

        class_3218 first = iter.next();
        class_3218 found = first;

        while (iter.hasNext()) {
            if (same(found.method_27983(), last)) {
                if (!iter.hasNext())
                    break;

                return iter.next();
            }

            found = iter.next();
        }

        return first;
    }

    private static boolean same(class_5321<class_1937> a, class_5321<class_1937> b) {
        return a == b || a.method_29177().equals(b.method_29177());
    }
}
