package dev.amble.ait.core.blockentities;


import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.blueprint.Blueprint;
import dev.amble.ait.core.item.blueprint.BlueprintItem;
import dev.amble.ait.core.item.blueprint.BlueprintSchema;
import dev.amble.ait.core.util.StackUtil;

public class FabricatorBlockEntity extends InteriorLinkableBlockEntity {
    private Blueprint blueprint;

    public FabricatorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.FABRICATOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void useOn(class_2680 state, class_1937 world, boolean sneaking, class_1657 player) {
        if (world.method_8608())
            return;

        if (!this.isValid())
            return;

        class_1799 hand = player.method_6047();

        // accept new blueprint
        if (!this.hasBlueprint() && hand.method_7909() instanceof BlueprintItem) {
            BlueprintSchema schema = BlueprintItem.getSchema(hand);

            if (schema == null)
                return;

            this.setBlueprint(schema.create());
            world.method_8396(null, this.method_11016(), AITSounds.FABRICATOR_START, class_3419.field_15245, 1, 1);
            return;
        }

        // try to insert items into the fabricator
        if (this.hasBlueprint()) {
            Blueprint blueprint = this.getBlueprint().get();

            if (hand.method_7960() && sneaking) {
                List<class_1799> inputs = blueprint.getInsertedItems();
                for (class_1799 stack : inputs) {
                    player.method_31548().method_7398(stack);
                }

                this.setBlueprint(null, true);
                this.sync();
                this.method_5431();

                return;
            }

            if (blueprint.tryAdd(hand)) {
                this.syncChanges();

                if (blueprint.isComplete())
                    world.method_8396(null, this.method_11016(), AITSounds.FABRICATOR_END, class_3419.field_15245, 1, 1);

                return;
            }

            // try to craft the blueprint
            Optional<class_1799> output = blueprint.tryCraft();
            if (output.isPresent()) {
                class_1799 stack = output.get();
                player.method_31548().method_7398(stack);

                this.setBlueprint(null, true);
                this.sync();
                this.method_5431();
            }
        }
    }

    public boolean isValid() {
        if (!this.method_11002())
            return false;

        return this.method_10997().method_8320(this.method_11016().method_10074()).method_27852(class_2246.field_16329);
    }

    public Optional<Blueprint> getBlueprint() {
        return Optional.ofNullable(this.blueprint);
    }

    public boolean hasBlueprint() {
        return this.getBlueprint().isPresent();
    }

    /**
     * attempts to set the blueprint of this fabricator
     * @return false if this fabricator already has a blueprint
     */
    public boolean setBlueprint(Blueprint blueprint, boolean force) {
        if (!force && this.hasBlueprint()) return false;
        this.blueprint = blueprint;
        this.syncChanges();
        return true;
    }
    /**
     * attempts to set the blueprint of this fabricator
     * @return false if this fabricator already has a blueprint
     */
    public boolean setBlueprint(Blueprint blueprint) {
        return this.setBlueprint(blueprint, false);
    }

    /**
     * @return the itemstack that should be displayed in the fabricator's renderer
     */
    public class_1799 getShowcaseStack() {
        if (this.hasBlueprint()) {
            if (this.blueprint.isComplete()) return this.blueprint.getOutput();

            // cycle through the requirements based off world ticks
            int index = (int) (field_11863.method_8510() / 20 % this.blueprint.getRequirements().size());
            return this.blueprint.getRequirements().get(index);
        }

        return class_1799.field_8037;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);

        this.blueprint = null;

        if (nbt.method_10545("Blueprint"))
            this.blueprint = new Blueprint(nbt.method_10562("Blueprint"));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        if (blueprint != null)
            nbt.method_10566("Blueprint", blueprint.toNbt());

        nbt.method_10556("HasBlueprint", this.hasBlueprint());
    }

    @Nullable @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    protected void syncChanges() {
        if (this.method_10997().method_8608())
            return;

        class_3218 world = (class_3218) this.method_10997();
        world.method_14178().method_14128(this.method_11016());
        this.method_5431();
    }

    public void onBroken() {
        if (this.hasBlueprint()) {
            this.getBlueprint().ifPresent(blueprint -> {
                class_1799 stack = AITItems.BLUEPRINT.method_7854();
                BlueprintItem.setSchema(stack, blueprint.getSource());

                StackUtil.spawn(this.method_10997(), this.method_11016(), stack);

                List<class_1799> inputs = blueprint.getInsertedItems();
                StackUtil.scatter(this.method_10997(), this.method_11016(), inputs);
            });
        }
    }
}
