package dev.amble.ait.core.blockentities;

import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.drinks.DrinkRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class FoodMachineBlockEntity extends InteriorLinkableBlockEntity {
    private Mode currentMode = Mode.FOOD_CUBES;
    private int currentIndex = 0;
    private long lastDrinkTime = 0;
    private class_1799 selectedItem;

    public FoodMachineBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.FOOD_MACHINE_BLOCK_ENTITY_TYPE, pos, state);
    }

    public enum Mode {
        FOOD_CUBES(278),
        DRINKS(386),
        OVERCHARGED_FOOD_CUBES(1328); // (FOOD_CUBES + DRINKS) * 2

        private final int fuelCost;

        Mode(int fuelCost) {
            this.fuelCost = fuelCost;
        }

        public int getFuelCost(){
            return fuelCost;
        }
    }

    public void eatFuel() {
        if (!this.isLinked()) return;
        this.tardis().get().fuel().removeFuel(this.getMode().getFuelCost());
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getMode() {
        return currentMode;
    }

    public int getCurrentIndex(){
        return this.currentIndex;
    }

    public void setCurrentIndex(int value) {
        int size = DrinkRegistry.getInstance().size();
        if (size == 0) {
            this.currentIndex = 0;
        } else {
            this.currentIndex = value % size;
        }
    }

    public boolean isPoweredOn(){
        return this.isLinked() && this.tardis().get().fuel().hasPower();
    }
    public class_1799 getSelectedItem() {
        return this.selectedItem;
    }
    public void setSelectedItem(class_1799 item){
        this.selectedItem = item;
    }

    public void setLastDrinkTime(long value){
        this.lastDrinkTime = value;
    }

    public long getLastDrinkTime(){
        return this.lastDrinkTime;
    }
}
