package dev.amble.ait.core.blockentities;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.blocks.MatrixEnergizerBlock;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6862;
import net.minecraft.class_8514;

public class MatrixEnergizerBlockEntity
        extends class_2586
        implements class_5714.class_8513<class_8514.class_8516>,
        class_8514 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_8514.class_8515 listenerData;
    private final class_8514.class_8516 listener;
    private final class_8514.class_5719 callback = this.createCallback();
    private int lastVibrationFrequency;

    protected MatrixEnergizerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.listenerData = new class_8514.class_8515();
        this.listener = new class_8514.class_8516(this);
    }

    public MatrixEnergizerBlockEntity(class_2338 pos, class_2680 state) {
        this(AITBlockEntityTypes.MATRIX_ENERGIZER_BLOCK_ENTITY_TYPE, pos, state);
    }

    public class_8514.class_5719 createCallback() {
        return new VibrationCallback(this.method_11016());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.lastVibrationFrequency = nbt.method_10550("last_vibration_frequency");
        if (nbt.method_10573("listener", class_2520.field_33260)) {
            class_8514.class_8515.field_44640.parse(new Dynamic<>(
                    class_2509.field_11560, nbt.method_10562("listener")))
                    .resultOrPartial(LOGGER::error).ifPresent(listener -> {
                this.listenerData = listener;
            });
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("last_vibration_frequency", this.lastVibrationFrequency);
        class_8514.class_8515.field_44640.encodeStart(class_2509.field_11560, this.listenerData)
                .resultOrPartial(LOGGER::error).ifPresent(listenerNbt -> nbt.method_10566("listener", listenerNbt));
    }

    @Override
    public class_8514.class_8515 method_51298() {
        return this.listenerData;
    }

    @Override
    public class_8514.class_5719 method_51299() {
        return this.callback;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int lastVibrationFrequency) {
        this.lastVibrationFrequency = lastVibrationFrequency;
    }

    @Override
    public class_8514.class_8516 method_51358() {
        return this.listener;
    }

    protected class VibrationCallback
            implements class_8514.class_5719 {
        protected final class_2338 pos;
        private final class_5716 positionSource;

        public VibrationCallback(class_2338 pos) {
            this.pos = pos;
            this.positionSource = new class_5707(pos);
        }

        @Override
        public int method_49797() {
            return 1;
        }

        @Override
        public class_5716 method_51300() {
            return this.positionSource;
        }

        @Override
        public boolean method_43695() {
            return true;
        }

        @Override
        public boolean method_32970(class_3218 world, class_2338 pos, class_5712 event, @Nullable class_5712.class_7397 emitter) {
            if (pos.equals(this.pos) && (event == class_5712.field_28165 || event == class_5712.field_28164)) {
                return false;
            }
            return MatrixEnergizerBlock.isInactive(MatrixEnergizerBlockEntity.this.method_11010());
        }

        @Override
        public class_6862<class_5712> method_42210() {
            return AITTags.GameEvents.MATRIX_CAN_LISTEN;
        }

        @Override
        public void method_32969(class_3218 world, class_2338 pos, class_5712 event, @Nullable class_1297 sourceEntity, @Nullable class_1297 entity, float distance) {
            class_2680 blockState = MatrixEnergizerBlockEntity.this.method_11010();
            if (MatrixEnergizerBlock.isInactive(blockState)) {
                MatrixEnergizerBlockEntity.this.setLastVibrationFrequency(class_8514.method_51385(event));
                class_2248 block = blockState.method_26204();
                if (event.equals(class_5712.field_38244) && block instanceof MatrixEnergizerBlock matrixEnergizerBlock) {
                    matrixEnergizerBlock.setActive(world, this.pos, blockState,
                            MatrixEnergizerBlockEntity.this.getLastVibrationFrequency());
                }
            }
        }

        @Override
        public void method_42672() {
            MatrixEnergizerBlockEntity.this.method_5431();
        }

        @Override
        public boolean method_51363() {
            return true;
        }
    }
}
