package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.SecurityControl;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class MonitorBlockEntity extends InteriorLinkableBlockEntity {

    public MonitorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.MONITOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (!(player instanceof class_3222 serverPlayer))
            return;

        if (this.tardis().isEmpty())
            return;

        Tardis tardis = this.tardis().get();

        if (!tardis.fuel().hasPower())
            return;

        boolean security = tardis.stats().security().get();

        if (security && !SecurityControl.hasMatchingKey(serverPlayer, tardis))
            return;

        player.method_5783(class_3417.field_15015.comp_349(), 1.0F, 1.0F);
        AITMod.openScreen(serverPlayer, 0, tardis.getUuid()); // we can cast because we know its on server :p
    }
}
