package dev.amble.ait.core.blockentities.control;

import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.blocks.control.RedstoneControlBlock;
import dev.amble.ait.core.item.control.ControlBlockItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.registry.impl.ControlRegistry;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;

public abstract class ControlBlockEntity extends InteriorLinkableBlockEntity {

    private Control control;
    private ConsoleTypeSchema consoleType;
    private boolean onDelay = false;

    protected ControlBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        if (this.getControl() != null)
            nbt.method_10582(ControlBlockItem.CONTROL_ID_KEY, this.getControl().id().toString());

        if (this.getConsoleType() != null)
            nbt.method_10582(ControlBlockItem.CONSOLE_TYPE_ID_KEY, this.getConsoleType().id().toString());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);

        if (nbt.method_10545(ControlBlockItem.CONTROL_ID_KEY))
            this.setControlId(new class_2960(nbt.method_10558(ControlBlockItem.CONTROL_ID_KEY)));

        if (nbt.method_10545(ControlBlockItem.CONSOLE_TYPE_ID_KEY))
            this.setConsoleId(new class_2960(nbt.method_10558(ControlBlockItem.CONSOLE_TYPE_ID_KEY)));
    }

    /**
     * Gets the control Can be null if this hasnt been linked
     *
     * @return control
     */
    public Control getControl() {
        return this.control;
    }

    public ConsoleTypeSchema getConsoleType() {
        if (this.consoleType == null) {
            // default
            this.consoleType = ConsoleRegistry.HARTNELL;
        }

        return this.consoleType;
    }

    public void setControlId(class_2960 id) {
        Optional<Control> found = ControlRegistry.fromId(id);

        if (found.isEmpty())
            return;

        this.control = found.get();
    }

    public void setConsoleId(class_2960 id) {
        Optional<ConsoleTypeSchema> found = ConsoleRegistry.getInstance().getOptional(id);

        if (found.isEmpty())
            return;

        this.consoleType = found.get();
    }

    public boolean run(class_3222 user, boolean isMine) {
        if (this.getControl() == null || this.onDelay)
            return false;

        TardisRef found = this.tardis();

        if (!(found.get() instanceof ServerTardis tardis))
            return false;

        if (!this.control.canRun(tardis, user))
            return false;

        if (this.control.shouldHaveDelay(tardis) && !this.onDelay)
            this.createDelay(this.control.getDelayLength(tardis));

        Control.Result result = this.control.handleRun(tardis, user, user.method_51469(), this.field_11867, isMine);
        this.method_10997().method_8396(null, field_11867, this.control.getSound(this.getConsoleType(), result), class_3419.field_15245, 0.7f, 1f);

        return result.isSuccess();
    }

    public boolean run(class_3222 user, RedstoneControlBlock.Mode mode) {
        return this.run(user, mode == RedstoneControlBlock.Mode.PUNCH);
    }

    public void createDelay(long ticks) {
        this.onDelay = true;

        Scheduler.get().runTaskLater(() -> this.onDelay = false, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, ticks);
    }
}
