package dev.amble.ait.core.blocks;

import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import dev.amble.lib.api.ICantBreak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.item.HammerItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.console.type.CopperType;
import dev.amble.ait.data.schema.console.type.CrystallineType;

public class ConsoleBlock extends HorizontalDirectionalBlock implements class_2343, ICantBreak {

    private static final class_265 SHAPE;

    static {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1082(shape, class_259.method_1081(0, 0, 0, 1, 0.875, 1), class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(0, 0.875, -0.25, 1, 1, 1.25), class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(0, 1, 0, 1, 1.125, 1), class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(-0.25, 0.875, 0, 1.25, 1, 1), class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(-0.1875, 0.875, -0.125, 1.1875, 1, 0),
                class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(-0.1875, 0.875, 1, 1.1875, 1, 1.125),
                class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(1, 0.875, -0.1875, 1.125, 1, 1.1875),
                class_247.field_1366);
        shape = class_259.method_1082(shape, class_259.method_1081(-0.125, 0.875, -0.1875, 0, 1, 1.1875),
                class_247.field_1366);

        SHAPE = shape;
    }

    public ConsoleBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ConsoleBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
                              class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ConsoleBlockEntity consoleBlockEntity) {
            if (world.method_27983().equals(class_1937.field_25179)) return class_1269.field_5814;
            consoleBlockEntity.useOn(world, player.method_5715(), player);
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() instanceof HammerItem) {
                itemStack.method_7909().method_7884(new class_1838(world, player, hand, itemStack, hit));
            }
        }

        if (world.method_8608()) {
            return class_1269.field_5812;
        }

        if (blockEntity instanceof ConsoleBlockEntity consoleBlockEntity) {
            if (!consoleBlockEntity.method_5442()) { // This is to ensure that the console doesnt get used as an extra chest and accidental misclicks
                player.method_17355(consoleBlockEntity);
                world.method_8396(null, pos, AITSounds.DOOM_DOOR_OPEN, class_3419.field_15245, 1.0f, 0.7f);
            }
        }

        return class_1269.field_5812;
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, @NotNull class_2680 state,
                                                                  @NotNull class_2591<T> type) {
        return (world1, blockPos, blockState, ticker) -> {
            if (ticker instanceof ConsoleBlockEntity console) {
                console.tick(world, blockPos, blockState, console);
            }
        };
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer,
                         class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);

        if (world.method_8321(pos) instanceof ConsoleBlockEntity consoleBlockEntity) {
            if (world.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            consoleBlockEntity.markNeedsControl();
        }
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ConsoleBlockEntity console && console.isLinked()) {
            Tardis tardis = console.tardis().get();
            if (console.tardis().get().fuel().hasPower()) {
                return 15;
            }
        }
        return 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return method_9524(state, world, pos, direction);
    }


    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!TardisServerWorld.isTardisDimension(world)) return;
        if (entity instanceof class_1657 player) {
            Random random = new Random();
            int x_random = random.nextInt(1, 10);
            int y_random = random.nextInt(1, 10);
            int z_random = random.nextInt(1, 10);

            boolean is_x_negative = false;
            boolean is_z_negative = false;
            if (random.nextInt(1, 3) == 1) {
                is_x_negative = true;
            }
            if (random.nextInt(1, 3) == 1) {
                is_z_negative = true;
            }

            world.method_8396(null, pos, AITSounds.CLOISTER, class_3419.field_15245, 4f, 1f);

            player.method_5762(0.15f * x_random * (is_x_negative ? -1 : 1), 0.1f * y_random,
                    0.15f * z_random * (is_z_negative ? -1 : 1));

            if (player instanceof class_3222) {
                for (int i = 0; i < 100; i++) {
                    ((class_3218) world).method_14199(class_2398.field_11231,
                            pos.method_10263() + random.nextFloat(-2, 3), pos.method_10264() + random.nextFloat(2),
                            pos.method_10260() + random.nextFloat(-2, 3), 1, random.nextFloat(-5, 5), random.nextFloat(-5, 5),
                            random.nextFloat(-5, 5), 1f);
                }
            }
        }
        super.method_9591(world, pos, state, entity);
    }

    // This will literally never happen
    @Override
    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);

        if (world.method_8321(pos) instanceof ConsoleBlockEntity console) {
            console.onBroken();
        }
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, net.minecraft.class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);

        if (blockEntity instanceof ConsoleBlockEntity consoleBlockEntity) {

            if (!consoleBlockEntity.isLinked()) return;

            if (!consoleBlockEntity.tardis().get().fuel().hasPower()) return;

            double d = pos.method_10263();
            double e = pos.method_10264();
            double f = pos.method_10260();

            if ((consoleBlockEntity.getTypeSchema() instanceof CrystallineType)) {

                for (int i = 0; i < random.method_43048(15) + 1; ++i) {
                    boolean bl = random.method_43056();
                    float particleSpeed = random.method_43057() / 15.0f;

                    world.method_8406(class_2398.field_11251,
                            (double) pos.method_10263() + 0.5,
                            (double) pos.method_10264() + 2,
                            (double) pos.method_10260() + 0.5,
                            bl ? particleSpeed : -particleSpeed,
                            2.2E-3,
                            bl ? particleSpeed : -particleSpeed);

                    world.method_8406(class_2398.field_11204,
                            pos.method_10263() + 0.5,
                            pos.method_10264() + 0.5,
                            pos.method_10260() + 0.5,
                            0.0,
                            0.1,
                            0.0);
                }
                return;
            }

            if (consoleBlockEntity.tardis() != null &&
                    !consoleBlockEntity.tardis().get().extra().getInsertedDisc().method_7960() &&
                    consoleBlockEntity.getTypeSchema() instanceof CopperType) {
                for (int i = 0; i < random.method_43048(10) + 1; ++i) {
                    boolean bl = random.method_43056();
                    float b = (float)world.method_8409().method_43048(4) / 24.0f;

                    world.method_8406(class_2398.field_11224,
                            d + 1.4,
                            e + 2.6,
                            f - 0.15f,
                            b + 1.5,
                            b,
                            b + 0.5);
                }
            }
        }
    }





    @Override
    public void onTryBreak(class_1937 world, class_2338 pos, class_2680 state) {
        if (TardisServerWorld.isTardisDimension(world)) return;

        world.method_22352(pos, true);
    }
}
