package dev.amble.ait.core.blocks;

import static dev.amble.ait.core.blockentities.ConsoleBlockEntity.previousConsole;
import static dev.amble.ait.core.blockentities.ConsoleBlockEntity.previousVariant;

import dev.amble.lib.api.ICantBreak;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blockentities.ConsoleGeneratorBlockEntity;
import dev.amble.ait.core.engine.link.block.FluidLinkBlock;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;
import dev.amble.ait.core.world.TardisServerWorld;

public class ConsoleGeneratorBlock extends FluidLinkBlock implements class_2343, ICantBreak {

    public ConsoleGeneratorBlock(class_2251 settings) {
        super(settings);
    }

    @Nullable @Override
    public FluidLinkBlockEntity method_10123(class_2338 pos, class_2680 state) {
        return new ConsoleGeneratorBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
            class_3965 hit) {

        if (world.method_8321(pos) instanceof ConsoleGeneratorBlockEntity be)
            be.useOn(world, player.method_5715(), false, player);

        return class_1269.field_5812;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        double centerX = pos.method_10263() + 0.5;
        double centerY = pos.method_10264() + 0.5;
        double centerZ = pos.method_10260() + 0.5;
        double radius = 1;
        double angle = random.method_43058() * 2 * Math.PI;
        int side = random.method_43048(4);

        double x = centerX;
        double y = centerY + (random.method_43058() - 0.5) * 0.2;
        double z = centerZ;

        switch (side) {
            case 0: // +X
                x += radius * Math.cos(angle);
                z += radius * Math.sin(angle);
                break;
            case 1: // -X
                x -= radius * Math.cos(angle);
                z += radius * Math.sin(angle);
                break;
            case 2: // +Z
                z += radius * Math.cos(angle);
                x += radius * Math.sin(angle);
                break;
            case 3: // -Z
                z -= radius * Math.cos(angle);
                x += radius * Math.sin(angle);
                break;
        }

        if (random.method_43048(5) == 0) {
            for (int i = 0; i < 3; i++) {
                world.method_8406(AITMod.CORAL_PARTICLE, x, y, z,
                        random.method_43059() * 0.01, random.method_43059() * 0.01, random.method_43059() * 0.01);
            }
        }
    }

    // Triggers instead of onTryBreak when punching in survival mode.
    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (world.method_8321(pos) instanceof ConsoleGeneratorBlockEntity be)
            be.useOn(world, player.method_5715(), true, player);
    }

    // Triggers instead of onBlockBreakStart when punching in creative mode.
    @Override
    public void onTryBreak(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (player == null)
            return;

        if (!TardisServerWorld.isTardisDimension(world) || !player.method_6047().method_7960()) {
            world.method_22352(pos, true);
            return;
        }

        if (world.method_8321(pos) instanceof ConsoleGeneratorBlockEntity be) {
            world.method_8396(null, pos, class_3417.field_37358, class_3419.field_15245, 0.5f, 1.0f);

            if (player.method_5715())
                be.changeConsole(previousVariant(be.getConsoleVariant()));
            else
                be.changeConsole(previousConsole(be.getConsoleSchema()));
        }
    }
}
