package dev.amble.ait.core.blocks;

import static dev.amble.ait.client.util.TooltipUtil.addShiftHiddenTooltip;

import java.util.List;
import java.util.UUID;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2492;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.blockentities.CoralBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.LoyaltyHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.exterior.variant.growth.CoralGrowthVariant;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

@SuppressWarnings("deprecation")
public class CoralPlantBlock extends HorizontalDirectionalBlock implements class_2343 {
    private final class_265 DEFAULT = class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 32.0, 16.0);
    public static final class_2758 AGE = class_2741.field_12550;

    public CoralPlantBlock(class_2251 settings) {
        super(settings);

        this.method_9590(
                this.method_9564().method_11657(AGE, 0)
        );
    }

    protected class_2758 getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(class_2680 state) {
        return state.method_11654(this.getAgeProperty());
    }

    public final boolean isMature(class_2680 blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);

        class_243 centre = pos.method_10084().method_46558();
        for (int i = 0; i < getAge(state); i++) {
            double offsetX = AITMod.RANDOM.nextGaussian() * getAge(state) * 0.01f;
            double offsetY = AITMod.RANDOM.nextGaussian() * getAge(state) * 0.01f;
            double offsetZ = AITMod.RANDOM.nextGaussian() * getAge(state) * 0.01f;
            world.method_8406(AITMod.CORAL_PARTICLE, centre.method_10216(), centre.method_10214() , centre.method_10215(), offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return true;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_22335(pos, 0) >= 4) {
            int i = this.getAge(state);
            if (i < this.getMaxAge()) {
                if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_2492)) {
                    world.method_22352(pos, true);
                    return;
                }

                world.method_8652(pos, state.method_11657(AGE, i + 1), 2);
            }
        }

        tryCreate(world, pos, state);
    }

    private boolean tryCreate(class_3218 world, class_2338 pos, class_2680 state) {
        if (!this.isMature(state))
            return false;

        if (TardisServerWorld.isTardisDimension(world)) {
            this.createConsole(world, pos);
            return true;
        }

        if (world.method_8321(pos) instanceof CoralBlockEntity coral)
            this.createTardis(world, pos, coral.creator, state);

        return true;
    }

    private void createConsole(class_3218 world, class_2338 pos) {
        world.method_45447(null, pos, AITSounds.FABRICATOR_END, class_3419.field_15245);

        world.method_8501(pos, AITBlocks.CONSOLE.method_9564());
    }

    private void createTardis(class_3218 world, class_2338 pos, UUID creatorId, class_2680 state) {
        if (!(world.method_18470(creatorId) instanceof class_3222 player))
            return;

        TardisBuilder builder = new TardisBuilder().at(CachedDirectedGlobalPos.create(world, pos,
                        CachedDirectedGlobalPos.getGeneralizedRotation(state.method_11654(FACING))))
                .owner(player)
                .<FuelHandler>with(TardisComponent.Id.FUEL, fuel -> fuel.setCurrentFuel(5000))
                .<LoyaltyHandler>with(TardisComponent.Id.LOYALTY, loyaltyHandler -> loyaltyHandler.set(player, new Loyalty(Loyalty.Type.NEUTRAL)))
                .with(TardisComponent.Id.TRAVEL, travel -> travel.tardis().travel().autopilot(false))
                .exterior(ExteriorVariantRegistry.getInstance().get(CoralGrowthVariant.REFERENCE))
                .desktop(DesktopRegistry.DEFAULT_CAVE);

        ServerTardis created = ServerTardisManager.getInstance()
                .create(builder);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer,
            class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);

        if (!(placer instanceof class_3222 player))
            return;

        if (!RiftChunkManager.isRiftChunk((class_3218) world, pos) && !TardisServerWorld.isTardisDimension((class_3218) world)) {
            world.method_22352(pos, !placer.method_31747() || !player.method_7337());
            return;
        }

        if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_2492)) {
            world.method_22352(pos, !placer.method_31747() || !player.method_7337());
            return;
        }

        if (world.method_8321(pos) instanceof CoralBlockEntity coral) {
            if (player.method_5667() != null) {
                coral.creator = player.method_5667();
                coral.method_5431();
            }
            TardisCriterions.PLACE_CORAL.trigger(player);
        }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return (world.method_22335(pos, 0) >= 4 || world.method_8311(pos)) && super.method_9558(state, world, pos);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1584 && world.method_8450().method_8355(class_1928.field_19388)) {
            world.method_8651(pos, true, entity);
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return DEFAULT;
    }

    @Override
    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return DEFAULT;
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return AITBlocks.CORAL_PLANT.method_8389().method_7854();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AGE).method_11667(FACING);
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);

        addShiftHiddenTooltip(stack, tooltip, tooltips -> {
            tooltip.add(class_2561.method_43471("tooltip.ait.tardis_coral").method_27695(class_124.field_1063, class_124.field_1056));
        });
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CoralBlockEntity(pos, state);
    }
}
