package dev.amble.ait.core.blocks;

import java.util.function.Function;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blockentities.DetectorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;

@SuppressWarnings("deprecation")
public class DetectorBlock extends class_2341 implements class_2343 {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2758 POWER = class_2741.field_12511;

    public static final class_2754<Type> TYPE = class_2754.method_11850("type", Type.class);

    protected static final class_265 NORTH_WALL_SHAPE = class_2248.method_9541(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final class_265 SOUTH_WALL_SHAPE = class_2248.method_9541(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final class_265 WEST_WALL_SHAPE = class_2248.method_9541(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final class_265 EAST_WALL_SHAPE = class_2248.method_9541(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final class_265 FLOOR_Z_AXIS_SHAPE = class_2248.method_9541(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final class_265 FLOOR_X_AXIS_SHAPE = class_2248.method_9541(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final class_265 CEILING_Z_AXIS_SHAPE = class_2248.method_9541(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final class_265 CEILING_X_AXIS_SHAPE = class_2248.method_9541(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    public DetectorBlock(class_4970.class_2251 settings) {
        super(settings.method_26249((state, world, pos) -> state.method_11654(POWERED))
                .method_9631(value -> value.method_11654(POWERED) ? 9 : 3));
        this.method_9590(this.field_10647.method_11664().method_11657(field_11177, class_2350.field_11043).method_11657(POWER, 0)
                .method_11657(POWERED, false).method_11657(field_11007, class_2738.field_12471).method_11657(TYPE, Type.POWER));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(field_11007)) {
            case field_12475 -> state.method_11654(field_11177).method_10166() == class_2350.class_2351.field_11048 ? FLOOR_X_AXIS_SHAPE : FLOOR_Z_AXIS_SHAPE;
            case field_12471 -> switch (state.method_11654(field_11177)) {
                case field_11034 -> EAST_WALL_SHAPE;
                case field_11039 -> WEST_WALL_SHAPE;
                case field_11035 -> SOUTH_WALL_SHAPE;
                default -> NORTH_WALL_SHAPE;
            };
            default -> state.method_11654(field_11177).method_10166() == class_2350.class_2351.field_11048 ? CEILING_X_AXIS_SHAPE : CEILING_Z_AXIS_SHAPE;
        };
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
            class_3965 hit) {
        if (!player.method_7294())
            return super.method_9534(state, world, pos, player, hand, hit);

        if (world.method_8608())
            return class_1269.field_5812;

        state = state.method_28493(TYPE);

        world.method_8652(pos, state, class_2248.field_31029);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286(player, state));
        return class_1269.field_21466;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved || state.method_27852(newState.method_26204()))
            return;

        if (state.method_11654(POWERED))
            this.updateNeighbors(state, world, pos);

        super.method_9536(state, world, pos, newState, false);
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(POWER);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11007, field_11177, POWERED, POWER, TYPE);
    }

    @Override
    public boolean method_9526(class_2680 state) {
        return true;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state,
            class_2591<T> type) {
        return checkType(type, AITBlockEntityTypes.DETECTOR_BLOCK_ENTITY_TYPE, DetectorBlock::tick);
    }

    @Nullable protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(
            class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? (class_5558<A>) ticker : null;
    }

    private void updateNeighbors(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8452(pos, this);
        world.method_8452(pos.method_10093(DetectorBlock.method_10119(state).method_10153()), this);
    }

    private static void updateState(class_2680 state, class_1937 world, class_2338 pos, Tardis tardis) {
        int power = state.method_11654(TYPE).getPower(tardis);

        world.method_8652(pos, state.method_11657(POWER, power).method_11657(POWERED, power != 0), field_31036);
    }

    private static void tick(class_1937 world, class_2338 pos, class_2680 state, DetectorBlockEntity detector) {
        if (world.method_8608() || !detector.isLinked())
            return;

        updateState(state, world, pos, detector.tardis().get());
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DetectorBlockEntity(pos, state);
    }

    public enum Type implements class_3542 {
        FLIGHT(tardis -> tardis.travel().getState() != TravelHandlerBase.State.LANDED ? 15 : 0), POWER(
                tardis -> tardis.fuel().hasPower() ? 15 : 0), CRASHED(tardis -> {
                    TardisCrashHandler.State state = tardis.crash().getState();

                    if (state == TardisCrashHandler.State.NORMAL)
                        return 0;

                    return state == TardisCrashHandler.State.UNSTABLE ? 7 : 15;
        }),
        DOOR_LOCKED(tardis -> tardis.door().locked() ? 15 : 0),
        DOOR_OPEN(tardis -> tardis.door().isOpen() ? 15 : 0),
        SONIC(tardis -> tardis.getDesktop().getConsolePos().stream().anyMatch(pos -> {
            class_2586 entity = tardis.asServer().world().method_8321(pos);
            if (entity instanceof ConsoleBlockEntity consoleBlock) {
                return consoleBlock.isLinked() && consoleBlock.getSonicScrewdriver() != null && !consoleBlock.getSonicScrewdriver().method_7960();
            }
            return false;
        }) ? 15 : 0),
        ALARMS(tardis -> tardis.alarm().isEnabled() ? 15 : 0);

        private final String name;
        private final Function<Tardis, Integer> func;

        Type(Function<Tardis, Integer> func) {
            this.name = this.toString().toLowerCase();
            this.func = func;
        }

        public int getPower(Tardis tardis) {
            return this.func.apply(tardis);
        }

        @Override
        public String method_15434() {
            return this.name;
        }
    }
}
