package dev.amble.ait.core.blocks;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.util.ShapeUtil;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.lib.data.CachedDirectedGlobalPos;

@SuppressWarnings("deprecation")
public class DoorBlock extends HorizontalDirectionalBlock implements class_2343, class_3737 {

    public static final class_265 NORTH_SHAPE = class_2248.method_9541(0.0, 0.0, 12.1, 16.0, 32.0, 16.0);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 LEVEL_4 = ExteriorBlock.LEVEL_4;

    static {
        TardisEvents.DOOR_OPEN.register(tardis -> {
            CachedDirectedGlobalPos globalPos = tardis.travel().position();
            class_2338 exteriorPos = globalPos.getPos();
            class_1937 exteriorWorld = globalPos.getWorld();

            class_2680 exteriorState = exteriorWorld.method_8320(exteriorPos);
            if (!tardis.travel().inFlight() && exteriorState.method_26204() instanceof ExteriorBlock)
                setDoorLight(tardis.asServer(), exteriorState.method_11654(ExteriorBlock.LEVEL_4));
        });

        TardisEvents.DOOR_CLOSE.register(tardis -> setDoorLight(tardis.asServer(), 0));
    }

    private static void setDoorLight(ServerTardis tardis, int level) {
        if (!tardis.hasWorld() || !tardis.world().shouldTick()) return;

        class_3218 world = tardis.world();

        // FIXME: ensure the DOOR_OPEN and DOOR_CLOSE events always get called on the main thread instead of doing this
        world.method_8503().execute(() -> {
            class_2338 pos = tardis.getDesktop().getDoorPos().getPos();

            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof DoorBlock))
                return;

            world.method_8501(pos, state.method_11657(LEVEL_4, level));
        });
    }

    @Override
    public float method_9520() {
        return 10000f;
    }

    public DoorBlock(class_2251 settings) {
        super(settings);

        this.method_9590(this.method_9595().method_11664()
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false)
                .method_11657(LEVEL_4, 0));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState,
            class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED))
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (world.method_8321(pos) instanceof DoorBlockEntity door && door.isLinked() &&
                door.tardis().get().siege() != null && door.tardis().get().siege().isActive())
            return class_259.method_1073();

        return ShapeUtil.rotate(class_2350.field_11043, state.method_11654(FACING), NORTH_SHAPE);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer,
            class_1799 itemStack) {

        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
            class_3965 hit) {
        if (world.method_8608())
            return class_1269.field_5812;

        if (world.method_8321(pos) instanceof DoorBlockEntity door)
            door.useOn(world, player.method_5715(), player);

        return class_1269.field_21466;
    }

    @Nullable @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state,
            class_2591<T> type) {
        return type == AITBlockEntityTypes.DOOR_BLOCK_ENTITY_TYPE ? DoorBlockEntity::tick : null;
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.method_8608())
            return;

        if (!(world.method_8321(pos) instanceof DoorBlockEntity door))
            return;

        if (!door.isLinked())
            return;

        if (door.tardis().get().siege().isActive())
            return;

//        if (door.tardis().get().stats().getYScale() == 0)
//            return;

        class_243 expansionBehind = new class_243(entity.field_6014, entity.field_6036, entity.field_5969).method_1020(entity.method_19538());
        class_243 expansionForward = entity.method_18798();

        class_238 entityBox = entity.method_5829().method_18804(expansionForward.method_1021(1.2)).method_18804(expansionBehind);

        class_238 doorShape = this.method_9530(state, world, pos, class_3726.method_16195(entity)).method_1107().method_996(pos);

        double insideBlockExpanded = 1.0E-7D;

        class_238 biggerEntityBox = entityBox.method_1014(insideBlockExpanded);
        class_238 biggerDoorShape = doorShape.method_1014(insideBlockExpanded);

        if (biggerEntityBox.method_994(biggerDoorShape))
            door.onEntityCollision(entity);
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);

        if (world.method_8608())
            return;

        if (!(world.method_8321(pos) instanceof DoorBlockEntity door))
            return;

        door.onBreak();
    }

    @Nullable @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153()).method_11657(WATERLOGGED,
                fluidState.method_15772() == class_3612.field_15910);
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DoorBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, LEVEL_4);
    }

    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return !(Boolean) state.method_11654(WATERLOGGED);
    }
}
