package dev.amble.ait.core.blocks;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blockentities.EngineBlockEntity;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlock;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;
import dev.amble.ait.core.world.TardisServerWorld;

public class EngineBlock extends SubSystemBlock implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;

    protected static final class_265 Y_SHAPE = class_259.method_1077();

    public EngineBlock(class_2251 settings) {
        super(settings, SubSystem.Id.ENGINE);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    @Nullable @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Nullable @Override
    public FluidLinkBlockEntity method_10123(class_2338 pos, class_2680 state) {
        return new EngineBlockEntity(pos, state);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world instanceof class_1937 world1 && TardisServerWorld.isTardisDimension(world1);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!(world.method_8321(pos) instanceof EngineBlockEntity engine))
            return;

        if (!engine.isLinked()) return;

        double offsetX = (random.method_43058() - 0.5) * 1.5;
        double offsetZ = (random.method_43058() - 0.5) * 1.5;
        double offsetY = 1.5 + random.method_43058();

        world.method_8466(AITMod.CORAL_PARTICLE, true, pos.method_10263() + 0.5 + offsetX, pos.method_10264() + offsetY,
                pos.method_10260() + 0.5 + offsetZ, 0, 0.05, 0);
        world.method_8466(class_2398.field_11215, true, pos.method_10263() + 0.5 + offsetX, pos.method_10264() + offsetY,
                pos.method_10260() + 0.5 + offsetZ, 0, 0.05, 0);

        float durability = engine.tardis().get().subsystems().engine().durability();

        if (durability > 10) return;

        world.method_8466(class_2398.field_11237, true, pos.method_10263() + 0.5, pos.method_10264() + 1.5,
                pos.method_10260() + 0.5, 0, 0.1, 0);
        world.method_8406(class_2398.field_11204, pos.method_10263() + 0.5, pos.method_10264() + 1.5,
                pos.method_10260() + 0.5, 0.1, 0, 0.05);

        world.method_8466(class_2398.field_11237, true, pos.method_10263() + 0.5, pos.method_10264() + 1.5,
                pos.method_10260() + 0.5, 0, 0.1, 0);
        world.method_8406(class_2398.field_11204, pos.method_10263() + 0.5, pos.method_10264() + 1.5,
                pos.method_10260() + 0.5, 0.1, 0, 0.05);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
}
