package dev.amble.ait.core.blocks;

import static dev.amble.ait.client.util.TooltipUtil.addShiftHiddenTooltip;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.blockentities.EnvironmentProjectorBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.tardis.Tardis;

@SuppressWarnings("deprecation")
public class EnvironmentProjectorBlock extends HorizontalDirectionalBlock implements class_2343 {
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 SILENT = class_2746.method_11825("silent");

    public EnvironmentProjectorBlock(class_2251 settings) {
        super(settings.method_26249((state, world, pos) -> state.method_11654(EnvironmentProjectorBlock.ENABLED)).method_22488()
                .method_9631(value -> value.method_11654(EnvironmentProjectorBlock.ENABLED) ? 9 : 3));
        this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Nullable @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = this.method_9564();
        boolean powered = ctx.method_8045().method_49803(ctx.method_8037());

        return blockState.method_11657(ENABLED, powered).method_11657(POWERED, powered).method_11657(SILENT,
                ctx.method_8045().method_8320(ctx.method_8037().method_10074()).method_26164(class_3481.field_15481))
                .method_11657(FACING, ctx.method_8042());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, ENABLED, POWERED, SILENT);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos,
                               boolean notify) {
        if (world.method_8608())
            return;

        if (world.method_8321(pos) instanceof EnvironmentProjectorBlockEntity projector)
            projector.neighborUpdate(state, world, pos);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
                              class_3965 hit) {
        if (world.method_8608())
            return class_1269.field_5811;

        if (hand != class_1268.field_5808)
            return class_1269.field_5811;

        if (world.method_8321(pos) instanceof EnvironmentProjectorBlockEntity projector)
            return projector.onUse(state, world, pos, player);

        return class_1269.field_5811;
    }

    @Override
    public boolean method_9526(class_2680 state) {
        return true;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public static void toggle(Tardis tardis, @Nullable class_1657 player, class_1937 world, class_2338 pos, class_2680 state,
                              boolean active) {
        if (world.method_8321(pos) instanceof EnvironmentProjectorBlockEntity projector)
            projector.toggle(tardis, state, active);

        if (state.method_11654(SILENT))
            return;

        world.method_8396(player, pos, active ? class_3417.field_14703 : class_3417.field_19344,
                class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);

        world.method_33596(player, active ? class_5712.field_28174 : class_5712.field_28175, pos);
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EnvironmentProjectorBlockEntity(pos, state);
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);

        addShiftHiddenTooltip(stack, tooltip, tooltips -> {
            tooltip.add(class_2561.method_43471("tooltip.ait.use_in_tardis").method_27695(class_124.field_1063, class_124.field_1056));
        });
    }
}
