package dev.amble.ait.core.blocks;

import java.util.function.ToIntFunction;

import dev.amble.ait.AITMod;
import dev.amble.lib.api.ICantBreak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_7718;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.ShapeUtil;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

@SuppressWarnings("deprecation")
public class ExteriorBlock extends class_2248 implements class_2343, ICantBreak, class_3737 {
    public static final byte MAX_ROTATION_INDEX = (byte) class_7718.method_45478();
    private static final int MAX_ROTATIONS = MAX_ROTATION_INDEX + 1;
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2758 LEVEL_4 = class_2741.field_12538;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final ToIntFunction<class_2680> STATE_TO_LUMINANCE = state -> state.method_11654(LEVEL_4);
    public static final class_265 LEDGE_DOOM = class_2248.method_9541(0, 0, -3.5, 16, 1, 16);
    public static final class_265 CUBE_NORTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0.0, 0.0, 5.0, 16.0, 32.0, 16.0), class_2248.method_9541(0, 0, -3.5, 16, 1, 16));
    public static final class_265 PORTALS_SHAPE = class_259.method_1084(
            class_2248.method_9541(0.0, 0.0, 11.0, 16.0, 32.0, 16.0), class_2248.method_9541(0, 0, -3.5, 16, 1, 16));

    public static final class_265 PORTALS_SHAPE_DIAGONAL = class_259.method_1084(
            class_2248.method_9541(11.0, 0.0, 11.0, 16.0, 32.0, 16.0), class_2248.method_9541(0, 0, -3.5, 16, 1, 16));
    public static final class_265 SIEGE_SHAPE = class_2248.method_9541(4.0, 0.0, 4.0, 12.0, 8.0, 12.0);
    public static final class_265 DIAGONAL_SHAPE;

    static {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072(shape, class_259.method_1081(-0.125, 0, -0.125, 0.875, 0.0625, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.25, 0.0625, 0.25, 0.875, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.3125, 0.0625, 0.1875, 0.875, 2, 0.25),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.1875, 0.0625, 0.3125, 0.25, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.125, 0.0625, 0.375, 0.1875, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.4375, 0.0625, 0.0625, 0.875, 2, 0.125),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.375, 0.0625, 0.125, 0.875, 2, 0.1875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.5625, 0.0625, -0.0625, 0.875, 2, 0),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.5, 0.0625, 0, 0.875, 2, 0.0625),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.625, 0.0625, -0.125, 0.875, 2, -0.0625),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0.0625, 0.0625, 0.4375, 0.125, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(0, 0.0625, 0.5, 0.0625, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(-0.0625, 0.0625, 0.5625, 0, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(-0.125, 0.0625, 0.625, -0.0625, 2, 0.875),
                class_247.field_1366);
        shape = class_259.method_1072(shape, class_259.method_1081(-0.3125, 0, -0.3125, 0.625, 0.0625, 0.625),
                class_247.field_1366);

        DIAGONAL_SHAPE = shape;
    }

    public ExteriorBlock(class_2251 settings) {
        super(settings.method_22488());

        this.method_9590(
                this.field_10647.method_11664().method_11657(ROTATION, 0).method_11657(WATERLOGGED, false).method_11657(LEVEL_4, 4));
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ExteriorBlockEntity exterior && exterior.isLinked()) {
            Tardis tardis = exterior.tardis().get();
            if (tardis != null && tardis.fuel().hasPower()) {
                return 15;
            }
        }
        return 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return method_9524(state, world, pos, direction);
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Nullable @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return this.method_9564().method_11657(ROTATION, 0).method_11657(WATERLOGGED, fluidState.method_15772() == class_3612.field_15910)
                .method_11657(LEVEL_4, 4);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(ROTATION, WATERLOGGED, LEVEL_4);
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return AITItems.TARDIS_ITEM.method_7854();
    }

    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return !(Boolean) state.method_11654(WATERLOGGED);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 blockEntity = world.method_8321(pos);
        class_265 normal = this.getNormalShape(state, false);

        if (!(blockEntity instanceof ExteriorBlockEntity exterior))
            return normal;

        if (!exterior.isLinked())
            return normal;

        Tardis tardis = exterior.tardis().get();

        if (tardis.siege() == null)
            return normal;

        if (tardis.siege().isActive())
            return SIEGE_SHAPE;

        TravelHandlerBase.State travelState = tardis.travel().getState();

        if (travelState == TravelHandlerBase.State.LANDED || tardis.travel().getAlpha() > 0.75)
            return normal;

        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti)
            return PORTALS_SHAPE;

        return class_259.method_1073();
    }

    @Override
    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 blockEntity = world.method_8321(pos);

        if (!(blockEntity instanceof ExteriorBlockEntity exterior) || !exterior.isLinked())
            return getNormalShape(state, false);

        if (!exterior.isLinked())
            return getNormalShape(state, false);

        Tardis tardis = exterior.tardis().get();

        if (tardis.siege().isActive())
            return SIEGE_SHAPE;

        if (tardis.getExterior().getVariant().equals(ExteriorVariantRegistry.DOOM))
            return LEDGE_DOOM;

        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && !tardis.door().isOpen() && tardis.getExterior().getVariant().hasPortals())
            return getNormalShape(state, true);

        if (tardis.chameleon().isApplied())
            return class_259.method_1073();

        TravelHandler travel = tardis.travel();

        if (travel.getState() == TravelHandlerBase.State.LANDED
                || travel.isHitboxShown())
            return getNormalShape(state, false);

        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti)
            return PORTALS_SHAPE;

        return class_259.method_1073();
    }

    // TODO cache this.
    public class_265 getNormalShape(class_2680 state, boolean ignorePortals) {
        class_2350 direction = class_7718.method_45480(state.method_11654(ROTATION))
                .orElse(null);

        class_265 shape;

        if (direction == null) {
            shape = DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && !ignorePortals ? PORTALS_SHAPE_DIAGONAL : DIAGONAL_SHAPE;
            direction = approximateDirection(state.method_11654(ROTATION));
        } else {
            shape = DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && !ignorePortals ? PORTALS_SHAPE : CUBE_NORTH_SHAPE;
        }

        return ShapeUtil.rotate(class_2350.field_11043, direction, shape);
    }

    public class_2350 approximateDirection(int rotation) {
        return switch (rotation) {
            default -> class_2350.field_11043;
            case 1, 2, 3 -> class_2350.field_11034;
            case 5, 6, 7 -> class_2350.field_11035;
            case 9, 10, 11 -> class_2350.field_11039;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 blockEntity = world.method_8321(pos);

        if (!(blockEntity instanceof ExteriorBlockEntity exterior) || !exterior.isLinked())
            return getNormalShape(state, false);

        Tardis tardis = exterior.tardis().get();

        TravelHandlerBase.State travelState = tardis.travel().getState();

        if (travelState == TravelHandlerBase.State.LANDED || tardis.travel().getAlpha() > 0.75)
            return getNormalShape(state, false);

        if (tardis.getExterior().getVariant().equals(ExteriorVariantRegistry.DOOM))
            return LEDGE_DOOM;

        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti)
            return PORTALS_SHAPE;

        return class_259.method_1073();
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
                              class_3965 hit) {
        if (world.method_8608())
            return class_1269.field_5812;

        if (!(world.method_8321(pos) instanceof ExteriorBlockEntity exterior))
            return class_1269.field_21466;

        if (exterior.tardis().isEmpty())
            return class_1269.field_5814;

        if (hit.method_17780() != class_2350.field_11036)
            exterior.useOn((class_3218) world, player.method_5715(), player);

        return class_1269.field_21466; // Consume the event regardless of the outcome
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.method_8608())
            return;

        if (world.method_8321(pos) instanceof ExteriorBlockEntity exterior)
            exterior.onEntityCollision(entity);
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ExteriorBlockEntity(pos, state);
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, @NotNull class_2680 state,
            @NotNull class_2591<T> type) {
        return (world1, blockPos, blockState, ticker) -> {
            if (ticker instanceof ExteriorBlockEntity exterior)
                exterior.tick(world, blockPos, blockState, exterior);
        };
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        //FIXME: re-enable this block after the exterior falling issues are resolved :(
        /*
        Tardis tardis = this.findTardis(world, pos);

        if (tardis == null)
            return;

        if (tardis.travel().getState() != TravelHandlerBase.State.LANDED
                || !canFallThrough(world, pos.down())) {
            tardis.flight().shouldFall().set(false);
            return;
        }

        tardis.flight().shouldFall().set(true);

        if (tardis.travel().antigravs().get() && tardis.fuel().hasPower())
            return;

        tardis.flight().onStartFalling(world, state, pos);

        if (state.get(WATERLOGGED))
            state.with(WATERLOGGED, false);
        */
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        world.method_39279(pos, this, 2);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos,
            boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);

        if (world.method_8608())
            return;

        Tardis tardis = this.findTardis(((class_3218) world), pos);

        if (tardis == null)
            return;

        tardis.<BiomeHandler>handler(TardisComponent.Id.BIOME).update();
    }

    private static boolean canFallThrough(class_1937 world, class_2338 pos) {
        Planet planet = PlanetRegistry.getInstance().get(world);

        if (planet != null && planet.zeroGravity())
            return false;

        class_2680 state = world.method_8320(pos);

        if (world.method_8320(pos.method_10074()).method_26204() == AITBlocks.EXTERIOR_BLOCK)
            return false;

        return canFallThrough(state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);

        if (world.method_8608())
            return;

        if (world.method_8321(pos) instanceof ExteriorBlockEntity exterior)
            exterior.validateExteriorPosition();
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);

        if (world.method_8608())
            return;

        if (world.method_8321(pos) instanceof ExteriorBlockEntity exterior)
            exterior.validateExteriorPosition();
    }

    private static boolean canFallThrough(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_51176() || state.method_45474();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState,
            class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED))
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));

        world.method_39279(pos, this, 2);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private Tardis findTardis(class_3218 world, class_2338 pos) {
        if (world.method_8321(pos) instanceof ExteriorBlockEntity exterior) {
            if (!exterior.isLinked() || exterior.tardis().isEmpty())
                return null;

            return exterior.tardis().get();
        }

        return null;
    }

    public void onLanding(Tardis tardis, class_3218 world, class_2338 pos) {
        if (tardis == null)
            return;

        tardis.flight().onLanding(world, pos);
        world.method_39279(pos, this, 2);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2338 blockPos = pos.method_10074();
        if (random.method_43048(16) == 0) {
            if (canFallThrough(world.method_8320(blockPos))) {
                class_5945.method_49099(world, pos, random, class_2398.field_11220);
            }
        }
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(ROTATION, rotation.method_10502(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(ROTATION, mirror.method_10344(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ExteriorBlockEntity exterior) {
            class_1297 seat = exterior.getSeatEntity(world);
            if (seat != null) {
                seat.method_5650(class_1297.class_5529.field_26999);
            }
        }
        super.method_9576(world, pos, state, player);
    }

}
