package dev.amble.ait.core.blocks;

import static dev.amble.ait.client.util.TooltipUtil.addShiftHiddenTooltip;

import java.util.List;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.FabricatorBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;

public class FabricatorBlock extends HorizontalDirectionalBlock implements class_2343 {

    public static final class_265 DEFAULT_SHAPE = class_259.method_1081(0, 0, 0, 1, (double) 2 / 16, 1);

    public FabricatorBlock(class_2251 settings) {
        super(settings);

        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer,
            class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        this.method_9590(state.method_11657(FACING, placer.method_5735().method_10153()));
    }

    @Override
    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        if (world.method_8321(pos) instanceof FabricatorBlockEntity be) {
            be.onBroken();
        }

        super.method_9586(world, pos, explosion);
    }

    @Override
    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8321(pos) instanceof FabricatorBlockEntity be) {
            be.onBroken();
        }

        super.method_9585(world, pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8321(pos) instanceof FabricatorBlockEntity be) {
            be.useOn(state, world, player.method_5715(), player);
            return class_1269.field_5812;
        }

        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return DEFAULT_SHAPE;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!(world.method_8321(pos) instanceof FabricatorBlockEntity be)) return;
        if (!be.isValid()) return;
        if (!be.hasBlueprint()) return;
        if (be.getBlueprint().orElseThrow().isComplete()) return;

        class_2350 direction = state.method_11654(FACING);
        double d = (double) pos.method_10263() + 0.55 - (double) (random.method_43057() * 0.1f);
        double e = (double) pos.method_10264() + 0.25 - (double) (random.method_43057() * 0.1f);
        double f = (double) pos.method_10260() + 0.55 - (double) (random.method_43057() * 0.1f);
        double g = 0.4f - (random.method_43057() + random.method_43057()) * 0.4f;
        world.method_8406(class_2398.field_22246, d + (double) direction.method_10148() * g,
                e + (double) direction.method_10164() * g, f + (double) direction.method_10165() * g,
                random.method_43059() * 0.005, random.method_43059() * 0.005, random.method_43059() * 0.005);

        if (random.method_43058() < 0.05) {
            world.method_8486(d, e, f, AITSounds.FABRICATOR_LOOP, class_3419.field_15245, 0.25f, 1.0f, false);
        }
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return DEFAULT_SHAPE;
    }

    @Override
    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return DEFAULT_SHAPE;
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FabricatorBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);

        addShiftHiddenTooltip(stack, tooltip, tooltips -> {
            tooltip.add(class_2561.method_43471("block.ait.fabricator.tooltip.use").method_27695(class_124.field_1063, class_124.field_1056));
        });
    }
}
