package dev.amble.ait.core.blocks;

import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_7718;
import net.minecraft.item.*;
import net.minecraft.util.*;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.FoodMachineBlockEntity;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.drinks.DrinkUtil;

public class FoodMachineBlock extends class_2237 implements class_2343 {
    public static final int MAX_ROTATION_INDEX = class_7718.method_45478();
    private static final int MAX_ROTATIONS = MAX_ROTATION_INDEX + 1;
    public static final class_2758 ROTATION = class_2741.field_12532;

    protected static final class_265 Y_SHAPE = class_2248.method_9541(
            2.0,
            0.0,
            2,
            14.0,
            25.0,
            14
    );

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    public FoodMachineBlock(class_2251 settings) {
        super(FabricBlockSettings.of()
                .method_9629(3.0F, 6.0F)
                .method_29292());
        this.method_9590(this.field_10647.method_11664().method_11657(ROTATION, 0));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof FoodMachineBlockEntity machine)) return class_1269.field_5812;
        if (!machine.isPoweredOn()) return class_1269.field_5811;
        class_1799 stack = player.method_5998(hand);

        // cycle through different modes
        if (player.method_5715() && stack.method_7960()) {
            world.method_8396(null, pos, AITSounds.LOAD_WAYPOINT, class_3419.field_15245, 1.0F, 1.0F);
            switch (machine.getMode()) {
                case FOOD_CUBES -> {
                    machine.setMode(FoodMachineBlockEntity.Mode.DRINKS);
                    player.method_7353(class_2561.method_43471("ait.foodmachine.mode.drinks").method_27661().method_27692(class_124.field_1075), true);
                }
                case DRINKS -> {
                    machine.setMode(FoodMachineBlockEntity.Mode.OVERCHARGED_FOOD_CUBES);
                    player.method_7353(class_2561.method_43471("ait.foodmachine.mode.overcharged_food_cubes").method_27661().method_27692(class_124.field_1076), true);
                }
                case OVERCHARGED_FOOD_CUBES -> {
                    machine.setMode(FoodMachineBlockEntity.Mode.FOOD_CUBES);
                    player.method_7353(class_2561.method_43471("ait.foodmachine.mode.food_cubes").method_27661().method_27692(class_124.field_1060), true);
                }

            }
            return class_1269.field_5812;
        }

        // logic for the current mode selected
        switch (machine.getMode()) {
            case FOOD_CUBES -> {
                machine.eatFuel();
                world.method_8396(null, pos, AITSounds.POWER_CONVERT, class_3419.field_15245, 1.0F, 1.0F);
                player.method_31548().method_7394(AITItems.FOOD_CUBE.method_7854());
            }
            case DRINKS -> {
                machine.eatFuel();
                world.method_8396(null, pos, AITSounds.COFFEE_MACHINE, class_3419.field_15245, 1.0F, 1.0F);
                if (machine.getSelectedItem() == null) {
                    machine.setSelectedItem(DrinkUtil.setDrink(new class_1799(AITItems.MUG), DrinkRegistry.getInstance().toList().get(1)));
                }
                player.method_31548().method_7394(machine.getSelectedItem().method_7972());
            }
            case OVERCHARGED_FOOD_CUBES -> {
                machine.eatFuel();
                world.method_8396(null, pos, AITSounds.POWER_CONVERT, class_3419.field_15245, 1.0F, 1.0F);
                player.method_31548().method_7394(AITItems.OVERCHARGED_FOOD_CUBE.method_7854());
            }

        }
        return class_1269.field_5812;
    }

    {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof FoodMachineBlockEntity machine)) return class_1269.field_5811;
            if (!machine.isPoweredOn()) return class_1269.field_5811;
            if (world.method_8320(pos).method_26204() instanceof FoodMachineBlock) {
                if (player.method_5715() && machine.getMode() == FoodMachineBlockEntity.Mode.DRINKS) {
                    if (!world.field_9236) {
                        long now = world.method_8510();
                        int cooldownTicks = 5;
                        if (now - machine.getLastDrinkTime() < cooldownTicks) {
                            return class_1269.field_5814;
                        }
                        machine.setLastDrinkTime(now);
                        int currentIndex = (machine.getCurrentIndex() + 1) % DrinkRegistry.getInstance().size();
                        machine.setCurrentIndex(currentIndex);
                        class_1799 selectedItem = DrinkUtil.setDrink(new class_1799(AITItems.MUG), DrinkRegistry.getInstance().toList().get(machine.getCurrentIndex()));
                        machine.setSelectedItem(selectedItem);
                        player.method_7353(class_2561.method_43469("ait.foodmachine.mode.refreshement_set_to", selectedItem.method_7964()), true);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return AITBlockEntityTypes.FOOD_MACHINE_BLOCK_ENTITY_TYPE.method_11032(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(ROTATION, class_7718.method_45479(ctx.method_8044()));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(ROTATION, rotation.method_10502(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(ROTATION, mirror.method_10344(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(ROTATION);
    }


}
