package dev.amble.ait.core.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.client.screens.LandingPadScreen;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.landing.LandingPadSpot;

public class LandingPadBlock extends class_2248 {
    private static final class_2746 ACTIVE = class_2746.method_11825("active"); // whether this block created a region

    public LandingPadBlock(FabricBlockSettings settings) {
        super(settings);

        this.method_9590(
                this.method_9595().method_11664().method_11657(ACTIVE, false)
        );
    }


    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);

        builder.method_11667(ACTIVE);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);

        class_243 centre = pos.method_10084().method_46558();
        world.method_8406(class_2398.field_28479, centre.method_10216(), centre.method_10214() - 0.5, centre.method_10215(), 0.0, 0.0, 0.0);

        // I hate this its so annoying </3
        //if (random.nextDouble() < 0.2f)
        //    world.playSound(centre.getX(), centre.getY(), centre.getZ(), SoundEvents.BLOCK_BELL_RESONATE, SoundCategory.BLOCKS, 0.1f, 1f, true);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            openScreen(pos);
            return super.method_9534(state, world, pos, player, hand, hit);
        }

        return class_1269.field_21466;
    }

    @Environment(EnvType.CLIENT)
    private static void openScreen(class_2338 pos) {
        class_310.method_1551().method_1507(new LandingPadScreen(pos));
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!(world instanceof class_3218 serverWorld))
            return;

        LandingPadManager manager = LandingPadManager.getInstance(serverWorld);

        if (manager.getRegionAt(pos) != null) {
            world.method_22352(pos, true);
            return;
        }

        world.method_8501(pos, state.method_11657(ACTIVE, true));
        manager.claim(pos);

        LandingPadRegion region = LandingPadManager.getInstance((class_3218) world).getRegionAt(pos);
        if (region != null) {
            for(LandingPadSpot spot : region.getSpots()) {
                spot.setPos(new class_2338(spot.getPos().method_10263(), world.method_8497(class_4076.method_18675(spot.getPos().method_10263()), class_4076.method_18675(spot.getPos().method_10260()))
                        .method_12005(class_2902.class_2903.field_13203, spot.getPos().method_10263() & 15, spot.getPos().method_10260() & 15) + 1, spot.getPos().method_10260()));
                LandingPadManager.Network.syncTracked(LandingPadManager.Network.Action.ADD, (class_3218) world, new class_1923(pos));
            }
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);

        if (!(world instanceof class_3218 serverWorld))
            return;

        if (!state.method_11654(ACTIVE)) return;

        LandingPadManager.getInstance(serverWorld).releaseAt(pos);
    }
}
