package dev.amble.ait.core.blocks;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_7718;
import dev.amble.ait.core.blockentities.MonitorBlockEntity;
import dev.amble.ait.core.util.MonitorStateUtil;

public class MonitorBlock extends class_2237 implements class_2343 {
    public static final int MAX_ROTATION_INDEX = class_7718.method_45478();
    private static final int MAX_ROTATIONS = MAX_ROTATION_INDEX + 1;
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2754<MonitorStateUtil> TEXTURE;
    protected static final class_265 SHAPE = class_2248.method_9541(4.0, 0.0, 4.0, 12.0, 8.0, 12.0);

    public MonitorBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(ROTATION, 0).method_11657(TEXTURE, MonitorStateUtil.DEFAULT));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MonitorBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
                              class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);

        if (blockEntity instanceof MonitorBlockEntity monitorBlockEntity)
            monitorBlockEntity.useOn(world, player.method_5715(), player);

        return class_1269.field_5812;
    }

    @Override
    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(ROTATION, class_7718.method_45479(ctx.method_8044()));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(ROTATION, rotation.method_10502(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(ROTATION, mirror.method_10344(state.method_11654(ROTATION), MAX_ROTATIONS));
    }


    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(ROTATION).method_11667(TEXTURE);
    }

    static {
        TEXTURE = class_2754.method_11850("skin", MonitorStateUtil.class);;
    }

}