package dev.amble.ait.core.blocks;

import static dev.amble.ait.client.util.TooltipUtil.addShiftHiddenTooltip;

import java.util.List;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import dev.amble.ait.api.ConsumableBlock;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.engine.link.block.DirectionalFluidLinkBlock;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;

public class PowerConverterBlock extends DirectionalFluidLinkBlock implements ConsumableBlock {

    public static final class_2753 FACING = class_2383.field_11177;
    protected static final class_265 Y_SHAPE = class_2248.method_9541(
            4.0,
            0.0,
            2.5,
            12.0,
            32.0,
            13.5
    );


    public PowerConverterBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Y_SHAPE;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);

        if (world.method_8321(pos) instanceof FluidLinkBlockEntity be) {
            if (world.method_8608()) return class_1269.field_5812;
            if (!(be.isPowered())) return class_1269.field_5814;
            if (!stack.method_31573(AITTags.Items.IS_TARDIS_FUEL) && !stack.method_7909().method_19263()) return class_1269.field_5814;

            if (!player.method_5715()) {
                be.source().addLevel(175);
                stack.method_7934(1);
            } else {
                int count = stack.method_7947();

                be.source().addLevel(175 * count);
                stack.method_7934(count);
            }

            if (stack.method_7909().method_19263()) {
                TardisCriterions.FEED_POWER_CONVERTER.trigger((class_3222) player);
            }

            world.method_8396(null, pos, AITSounds.POWER_CONVERT, class_3419.field_15245, 1.0F, 1.0F);

            return class_1269.field_5812;
        }

        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    public boolean canAcceptItem(class_1937 world, class_2338 pos, class_1799 stack, class_2350 from) {
        return stack.method_31573(AITTags.Items.IS_TARDIS_FUEL);
    }

    @Override
    public class_1799 insertItem(class_1937 world, class_2338 pos, class_1799 stack, class_2350 from, boolean simulate) {
        if (!(world.method_8321(pos) instanceof FluidLinkBlockEntity be)) return stack;

        if (!be.isPowered()) return stack;

        if (!simulate && !world.field_9236) {
            be.source().addLevel(175);
            world.method_8396(null, pos, AITSounds.POWER_CONVERT, class_3419.field_15245, 1.0F, 1.0F);
        }

        class_1799 leftover = stack.method_7972();
        leftover.method_7934(1);

        return leftover.method_7960() ? class_1799.field_8037 : leftover;
    }

    @Override
    public @Nullable BlockEntity method_10123(class_2338 pos, class_2680 state) {
        return new BlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public static class BlockEntity extends FluidLinkBlockEntity {
        public BlockEntity(class_2338 pos, class_2680 state) {
            super(AITBlockEntityTypes.POWER_CONVERTER_BLOCK_TYPE, pos, state);
        }
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);


        addShiftHiddenTooltip(stack, tooltip, tooltips -> {
            tooltip.add(class_2561.method_43471("tooltip.ait.power_converter").method_27695(class_124.field_1063, class_124.field_1056));
        });
    }
}
