package dev.amble.ait.core.blocks;

import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blockentities.AITRadioBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class RadioBlock extends HorizontalDirectionalBlock implements class_2343 {

    public static final class_265 X_AXIS_RADIO = class_2248.method_9541(2.5, 0.0, 0.0, 13.5, 12.0, 16.0);
    public static final class_265 PX_AXIS_TUNER = class_2248.method_9541(1.5, 2.5, 11.5, 3.5, 4.5, 13.5);
    public static final class_265 PX_AXIS_VOLUME = class_2248.method_9541(1.5, 2.5, 2.5, 3.5, 4.5, 4.5);
    public static final class_265 NX_AXIS_TUNER = class_2248.method_9541(12.5, 2.5, 2.5, 14.5, 4.5, 4.5);
    public static final class_265 NX_AXIS_VOLUME = class_2248.method_9541(12.5, 2.5, 11.5, 14.5, 4.5, 13.5);

    // -------------------------------------------------------------------------------------------------------------------------------------------
    public static final class_265 Z_AXIS_RADIO = class_2248.method_9541(0.0, 0.0, 2.5, 16, 12.0, 13.5);
    public static final class_265 PZ_AXIS_TUNER = class_2248.method_9541(2.5, 2.5, 1.5, 4.5, 4.5, 3.5);
    public static final class_265 PZ_AXIS_VOLUME = class_2248.method_9541(11.5, 2.5, 1.5, 13.5, 4.5, 3.5);
    public static final class_265 NZ_AXIS_TUNER = class_2248.method_9541(11.5, 2.5, 12.5, 13.5, 4.5, 14.5);
    public static final class_265 NZ_AXIS_VOLUME = class_2248.method_9541(2.5, 2.5, 12.5, 4.5, 4.5, 14.5);
    private static final class_265 PX_AXIS_SHAPE = class_259.method_17786(X_AXIS_RADIO, PX_AXIS_TUNER, PX_AXIS_VOLUME);
    private static final class_265 PZ_AXIS_SHAPE = class_259.method_17786(Z_AXIS_RADIO, PZ_AXIS_TUNER, PZ_AXIS_VOLUME);
    private static final class_265 NX_AXIS_SHAPE = class_259.method_17786(X_AXIS_RADIO, NX_AXIS_TUNER, NX_AXIS_VOLUME);
    private static final class_265 NZ_AXIS_SHAPE = class_259.method_17786(Z_AXIS_RADIO, NZ_AXIS_TUNER, NZ_AXIS_VOLUME);

    private class_265 shape;

    public RadioBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
        this.shape = class_259.method_1073();
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = state.method_11654(FACING);
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            if (direction == class_2350.field_11039) {
                this.shape = PX_AXIS_SHAPE;
            } else {
                this.shape = NX_AXIS_SHAPE;
            }
        }
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            if (direction == class_2350.field_11043) {
                this.shape = PZ_AXIS_SHAPE;
            } else {
                this.shape = NZ_AXIS_SHAPE;
            }
        }
        return this.shape;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
            class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof AITRadioBlockEntity radioBlockEntity) {
            radioBlockEntity.useOn(hit, state, player, world, player.method_5715());
        }
        return class_1269.field_21466;
    }

    @Nullable protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(
            class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? (class_5558<A>) ticker : null;
    }

    @Nullable @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state,
            class_2591<T> type) {
        return checkType(type, AITBlockEntityTypes.AIT_RADIO_BLOCK_ENTITY_TYPE,
                (world1, pos, state1, be) -> AITRadioBlockEntity.tick(world1, pos, state1, be));
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AITRadioBlockEntity(pos, state);
    }

    @Override
    public class_2680 getAppearance(class_2680 state, class_1920 renderView, class_2338 pos, class_2350 side,
            @Nullable class_2680 sourceState, @Nullable class_2338 sourcePos) {
        return super.getAppearance(state, renderView, pos, side, sourceState, sourcePos);
    }
}
