package dev.amble.ait.core.blocks;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class TardisCoralWallBlock
        extends TardisCoralFanBlock {
    public static final class_2753 FACING = class_2383.field_11177;
    private static final Map<class_2350, class_265> FACING_TO_SHAPE = Maps.newEnumMap(ImmutableMap.of(class_2350.field_11043, class_2248.method_9541(0.0, 4.0, 5.0, 16.0, 12.0, 16.0), class_2350.field_11035, class_2248.method_9541(0.0, 4.0, 0.0, 16.0, 12.0, 11.0), class_2350.field_11039, class_2248.method_9541(5.0, 4.0, 0.0, 16.0, 12.0, 16.0), class_2350.field_11034, class_2248.method_9541(0.0, 4.0, 0.0, 11.0, 12.0, 16.0)));

    public TardisCoralWallBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, true));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return FACING_TO_SHAPE.get(state.method_11654(FACING));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654(FACING) && !state.method_26184(world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = state.method_11654(FACING);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206(world, blockPos, direction);
    }

    @Override
    @Nullable public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions;
        class_2680 blockState = super.method_9605(ctx);
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        for (class_2350 direction : directions = ctx.method_7718()) {
            if (!direction.method_10166().method_10179() || !(blockState =
                    blockState.method_11657(FACING, direction.method_10153())).method_26184(worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}
