package dev.amble.ait.core.blocks;

import java.util.Optional;

import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.util.math.*;
import dev.amble.ait.core.blockentities.WaypointBankBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.util.WorldUtil;

@SuppressWarnings("deprecation")
public class WaypointBankBlock extends HorizontalDirectionalBlock implements class_2343 {

    public static final class_2754<class_2756> HALF = class_2741.field_12533;

    public static final int MAX_COUNT = 16;

    public WaypointBankBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(HALF,
                class_2756.field_12607));
    }

    private static int getSlotForHitPos(class_241 hitPos, class_2756 half) {
        int column = hitPos.field_1343 >= 0.5f ? 1 : 0;

        if (half == class_2756.field_12609)
            return column * (MAX_COUNT / 2);

        int row = (int) ((1 - hitPos.field_1342) * MAX_COUNT / 2);
        row = class_3532.method_15340(row, 0, 6);

        return row + column * (MAX_COUNT / 2) + 1;
    }

    private static Optional<class_241> getHitPos(class_3965 hit, class_2350 facing) {
        class_2350 direction = hit.method_17780();

        if (facing != direction)
            return Optional.empty();

        class_2338 blockPos = hit.method_17777().method_10093(direction);
        class_243 vec3d = hit.method_17784().method_1023(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());

        double x = vec3d.method_10216();
        double y = vec3d.method_10214();
        double z = vec3d.method_10215();

        return switch (direction) {
            case field_11043 -> Optional.of(new class_241((float) (1.0 - x), (float) y));
            case field_11035 -> Optional.of(new class_241((float) x, (float) y));
            case field_11039 -> Optional.of(new class_241((float) z, (float) y));
            case field_11034 -> Optional.of(new class_241((float) (1.0 - z), (float) y));
            case field_11033, field_11036 -> Optional.empty();
        };
    }

    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (world.method_8321(pos) instanceof WaypointBankBlockEntity bank)
            bank.unselect();
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
            class_3965 hit) {
        Optional<class_241> hitPos = getHitPos(hit, state.method_11654(class_2383.field_11177));

        if (hitPos.isEmpty())
            return class_1269.field_5811;

        if (state.method_11654(HALF) == class_2756.field_12609)
            pos = pos.method_10074();

        if (!(world.method_8321(pos) instanceof WaypointBankBlockEntity bank))
            return class_1269.field_5811;

        int slot = getSlotForHitPos(hitPos.get(), state.method_11654(HALF));
        return bank.onUse(world, state, player, hand, slot);
    }

    @Override
    public long method_9535(class_2680 state, class_2338 pos) {
        return class_3532.method_15371(pos.method_10263(), pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(),
                pos.method_10260());
    }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(HALF) == class_2756.field_12609)
            return null;

        return new WaypointBankBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, HALF);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8652(pos.method_10084(), state.method_11657(HALF, class_2756.field_12609), class_2248.field_31036);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState,
            class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 half = state.method_11654(HALF);

        if (direction.method_10166() == class_2350.class_2351.field_11052 && half == class_2756.field_12607 == (direction == class_2350.field_11036))
            return neighborState.method_27852(this) && neighborState.method_11654(HALF) != half
                    ? state.method_11657(FACING, neighborState.method_11654(FACING))
                    : class_2246.field_10124.method_9564();

        return half == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184(world, pos)
                ? class_2246.field_10124.method_9564()
                : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_1937 world = ctx.method_8045();

        if (blockPos.method_10264() < world.method_31600() - 1 && world.method_8320(blockPos.method_10084()).method_26166(ctx))
            return super.method_9605(ctx).method_11657(HALF, class_2756.field_12607);

        return null;
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && player.method_7337())
            WorldUtil.onBreakHalfInCreative(world, pos, state, player);

        super.method_9576(world, pos, state, player);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204()))
            return;

        if (world.method_8321(pos) instanceof WaypointBankBlockEntity bank) {
            bank.dropItems();
            world.method_8455(pos, this);
        }

        super.method_9536(state, world, pos, newState, moved);
    }
}
