package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.JsonElementArgumentType;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class DataCommand {

    public static final SuggestionProvider<class_2168> COMPONENT_SUGGESTION = (context,
            builder) -> class_2172.method_9264(
                    TardisComponentRegistry.getInstance().getValues().stream().map(TardisComponent.IdLike::name),
                    builder);

    public static final SuggestionProvider<class_2168> VALUE_SUGGESTION = (context, builder) -> {
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        String rawComponent = StringArgumentType.getString(context, "component");

        TardisComponent.IdLike id = TardisComponentRegistry.getInstance().get(rawComponent);

        if (!(tardis.handler(id) instanceof KeyedTardisComponent keyed))
            return builder.buildFuture(); // womp womp

        return class_2172.method_9264(
                keyed.getPropertyData().values().stream().map(value -> value.getProperty().getName()), builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("data").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.data", 2))

                .then(method_9244("tardis", TardisArgumentType.tardis()).then(method_9244("component",
                        StringArgumentType.word())
                        .suggests(COMPONENT_SUGGESTION)
                        .then(method_9244("value", StringArgumentType.word()).suggests(VALUE_SUGGESTION)
                                .then(method_9247("set").then(method_9244("data", JsonElementArgumentType.jsonElement())
                                        .executes(DataCommand::runSet)))
                                .then(method_9247("get").executes(DataCommand::runGet)))))));
    }

    private static <T> int runGet(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Value<T> value = getValue(context, tardis);

        if (value == null)
            return 0;

        T obj = value.get();

        String json = ServerTardisManager.getInstance().getFileGson().toJson(obj);

        source.method_45068(class_2561.method_43469("command.ait.data.get",
                value.getProperty().getName(), json));

        return Command.SINGLE_SUCCESS;
    }

    @SuppressWarnings("unchecked")
    private static <T> int runSet(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        Value<T> value = getValue(context, tardis);

        if (value == null)
            return 0;

        JsonElement data = JsonElementArgumentType.getJsonElement(context, "data");

        Class<?> classOfT = value.getProperty().getType().getClazz();
        T obj = (T) ServerTardisManager.getInstance().getFileGson().fromJson(data, classOfT);

        value.set(obj);
        source.method_45068(class_2561.method_43469("command.ait.data.set",
                value.getProperty().getName(), obj.toString()));

        return Command.SINGLE_SUCCESS;
    }

    private static <T> Value<T> getValue(CommandContext<class_2168> context, Tardis tardis) {
        String valueName = StringArgumentType.getString(context, "value");
        String rawComponent = StringArgumentType.getString(context, "component");

        TardisComponent.IdLike id = TardisComponentRegistry.getInstance().get(rawComponent);

        if (!(tardis.handler(id) instanceof KeyedTardisComponent keyed)) {
            context.getSource().method_45068(class_2561.method_43469("command.ait.data.fail", valueName, rawComponent));
            return null; // womp womp
        }

        return keyed.getPropertyData().getExact(valueName);
    }
}
