package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.WorldWithTardis;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DebugCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("debug").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.debug", 2)).executes(DebugCommand::execute)
                .then(method_9244("tardis", TardisArgumentType.tardis()).executes(DebugCommand::executeTardis)
                        .then(method_9244("player", class_2186.method_9305()).executes(DebugCommand::executePlayer)))));

    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();

        if (!source.method_43737())
            return Command.SINGLE_SUCCESS;

        class_3218 world = source.method_9225();
        class_1657 player = source.method_44023();

        LandingPadRegion region = LandingPadManager.getInstance(world).getRegion(player.method_31476());

        if (region != null)
            source.method_45068(class_2561.method_43470("LP in chunk: " + region));

        ((WorldWithTardis) context.getSource().method_9225()).ait$withLookup(lookup -> {
            source.method_45068(class_2561.method_43473());
            source.method_45068(class_2561.method_43470("TARDIS in chunk: " + lookup.get(source.method_44023().method_31476())));
        });

        return Command.SINGLE_SUCCESS;
    }

    private static int executeTardis(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();

        if (!source.method_43737())
            return 0;

        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        context.getSource().method_9211().method_40000(() -> {
            tardis.chameleon().clearDisguise();
            tardis.chameleon().applyDisguise();
        });
        return Command.SINGLE_SUCCESS;
    }

    private static int executePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, "player");
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        long start = System.nanoTime();
        NetworkUtil.hasLinkedItem(tardis, player);

        context.getSource().method_9226(() -> class_2561.method_43470("Checked player in "
                + (System.nanoTime() - start) + "ns"), false);

        return Command.SINGLE_SUCCESS;
    }
}
