package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import dev.drtheo.queue.api.util.block.ChunkEraser;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;

public class EraseChunksCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("erase-chunks").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.erase-chunks", 2))
                .then(method_9244("from", class_2264.method_9701())
                        .then(method_9244("to", class_2264.method_9701())
                                .executes(EraseChunksCommand::execute)))));

    }

    private static int execute(CommandContext<class_2168> context) {
        class_2265 from = class_2264.method_9702(context, "from");
        class_2265 to = class_2264.method_9702(context, "to");

        new ChunkEraser.Builder()
                .withFlags(class_2248.field_31031 | class_2248.field_31030)
                .build(context.getSource().method_9225(), from.method_34873(), to.method_34873())
                .execute();

        return Command.SINGLE_SUCCESS;
    }
}
