package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class FlightCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("flight").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.flight", 2))
                        .then(method_9244("tardis", TardisArgumentType.tardis())
                                .executes(FlightCommand::execute))));

    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = context.getSource().method_44023();

        if (player == null)
            return 0;

        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        if (!AITMod.CONFIG.rwfEnabled) {
            player.method_7353(class_2561.method_43471("tardis.message.control.rwf_disabled"), true);
            return Command.SINGLE_SUCCESS;
        }

        if (!player.method_7337()) {
            player.method_7353(class_2561.method_43471("tardis.message.control.rwf_creative_only"), true);
            return Command.SINGLE_SUCCESS;
        }

        context.getSource().method_9211().method_40000(()
                -> tardis.flight().enterFlight(player));

        return Command.SINGLE_SUCCESS;
    }
}
