package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.util.TextUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class FuelCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher
                .register(method_9247(AITMod.MOD_ID).then(method_9247("fuel").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel", 2))
                        .then(method_9247("add").then(method_9244("tardis", TardisArgumentType.tardis())
                                .then(method_9244("amount", DoubleArgumentType.doubleArg(0, FuelHandler.TARDIS_MAX_FUEL))
                                        .executes(FuelCommand::add))))
                        .then(method_9247("remove").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.remove", 2))
                                .then(method_9244("tardis", TardisArgumentType.tardis()).then(
                                        method_9244("amount", DoubleArgumentType.doubleArg(0, FuelHandler.TARDIS_MAX_FUEL))
                                                .executes(FuelCommand::remove))))
                        .then(method_9247("set").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.set", 2))
                                .then(method_9244("tardis", TardisArgumentType.tardis()).then(
                                        method_9244("amount", DoubleArgumentType.doubleArg(0, FuelHandler.TARDIS_MAX_FUEL))
                                                .executes(FuelCommand::set))))
                        .then(method_9247("get").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.get", 2))
                                .then(method_9244("tardis", TardisArgumentType.tardis()).executes(FuelCommand::get)))));
    }

    private static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        double fuel = DoubleArgumentType.getDouble(context, "amount");
        tardis.addFuel(fuel);

        source.method_45068(
                class_2561.method_43469("message.ait.fuel.add", fuel, TextUtil.forTardis(tardis), tardis.getFuel()));

        return Command.SINGLE_SUCCESS;
    }

    private static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        double fuel = DoubleArgumentType.getDouble(context, "amount");
        tardis.removeFuel(fuel);

        source.method_45068(
                class_2561.method_43469("message.ait.fuel.remove", fuel, TextUtil.forTardis(tardis), tardis.getFuel()));

        return Command.SINGLE_SUCCESS;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        double fuel = DoubleArgumentType.getDouble(context, "amount");

        if (fuel > FuelHandler.TARDIS_MAX_FUEL) {
            source.method_45068(class_2561.method_43471("message.ait.fuel.max"));
            return 0;
        }

        tardis.setFuelCount(fuel);
        source.method_45068(class_2561.method_43469("message.ait.fuel.set", TextUtil.forTardis(tardis), fuel));

        return Command.SINGLE_SUCCESS;
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        double fuel = tardis.fuel().getCurrentFuel();
        source.method_45068(class_2561.method_43469("message.ait.fuel.get", TextUtil.forTardis(tardis), fuel));

        return (int) fuel;
    }
}
