package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class GetNameCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID)
                .then(method_9247("name").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.name", 2)).then(method_9247("get")
                        .then(method_9244("tardis", TardisArgumentType.tardis()).executes(GetNameCommand::runCommand)))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        source.method_45068(class_2561.method_48322("command.tardis.ait.name", "TARDIS name: %s", tardis.stats().getName()));
        return Command.SINGLE_SUCCESS;
    }
}
