package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.util.TextUtil;

public class ListCommand {

    private static final Map<String, Function<ServerTardis, String>> SEARCH_TYPES = Map.of(
            "id", tardis -> tardis.getUuid().toString(),
            "owner", tardis -> tardis.stats().getPlayerCreatorName(),
            "name", tardis -> tardis.stats().getName()
    );

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("list")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.list", 2)).executes(ListCommand::list)
                .then(method_9244("search-args", StringArgumentType.greedyString())
                        .executes(ListCommand::search))
        ));
    }

    public static int list(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        source.method_45068(class_2561.method_43470("TARDIS':"));

        ServerTardisManager.getInstance().forEach(tardis -> sendTardis(source, tardis));
        return Command.SINGLE_SUCCESS;
    }

    public static int search(CommandContext<class_2168> context) {
        String args = StringArgumentType.getString(context, "search-args");

        class_2168 source = context.getSource();
        source.method_45068(class_2561.method_43471("command.ait.list.tardises"));

        String[] parts = args.split(":");

        String type = parts[0];

        try {
            Function<ServerTardis, String> func = SEARCH_TYPES.get(type);

            if (func == null)
                throw new IllegalArgumentException();

            Pattern value = Pattern.compile(parts[1]);

            ServerTardisManager.getInstance().forEach(tardis -> {
                boolean matches = value.matcher(func.apply(tardis)).matches();

                if (matches)
                    sendTardis(source, tardis);
            });
        } catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            context.getSource().method_9213(class_2561.method_43471("command.ait.list.pattern.error"));
            return 0;
        }

        return Command.SINGLE_SUCCESS;
    }

    private static void sendTardis(class_2168 source, ServerTardis tardis) {
        source.method_45068(class_2561.method_43470("  - ").method_10852(TextUtil.forTardis(tardis)));
    }
}
