package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.util.TextUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class LoadCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("load")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.load", 2)).executes(LoadCommand::load)
                .then(method_9244("target", TardisArgumentType.tardis())
                        .executes(LoadCommand::search))
        ));
    }

    public static int load(CommandContext<class_2168> context) {
        ServerTardisManager.getInstance().loadAll(context.getSource().method_9211(), (tardis -> sendTardis(context.getSource(), tardis)));

        return Command.SINGLE_SUCCESS;
    }

    public static int search(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTardis loaded = TardisArgumentType.getTardis(context, "target");
        class_2168 source = context.getSource();
        sendTardis(source, loaded);

        return Command.SINGLE_SUCCESS;
    }

    private static void sendTardis(class_2168 source, ServerTardis loaded) {
        class_2561 message = loaded != null ? class_2561.method_43470("Loaded: ").method_10852(TextUtil.forTardis(loaded)) : class_2561.method_43470("No TARDIS found with that UUID.");

        source.method_45068(message); // todo - translatable
    }
}
