package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.LoyaltyHandler;
import dev.amble.ait.data.Loyalty;

public class LoyaltyCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("loyalty")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.loyalty", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis())
                        .then(method_9244("player", class_2186.method_9305()).executes(LoyaltyCommand::get).then(
                                method_9244("value", IntegerArgumentType.integer()).executes(LoyaltyCommand::set))))));
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        CommonArgs args = CommonArgs.create(context);
        int value = IntegerArgumentType.getInteger(context, "value");

        args.run("ait.command.loyalty.set", "Set loyalty for player %s to rank %s level %s",
                handler -> handler.set(args.player, Loyalty.fromLevel(value)));

        return Command.SINGLE_SUCCESS;
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        CommonArgs args = CommonArgs.create(context);

        return args.run("ait.command.loyalty.get", "Player %s has rank %s with level %s",
                handler -> handler.get(args.player)).level();
    }

    record CommonArgs(class_2168 source, ServerTardis tardis, class_3222 player) {

        public static CommonArgs create(CommandContext<class_2168> context) throws CommandSyntaxException {
            ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
            class_3222 player = class_2186.method_9315(context, "player");

            return new CommonArgs(context.getSource(), tardis, player);
        }

        public Loyalty run(String key, String fallback, Function<LoyaltyHandler, Loyalty> func) {
            Loyalty result = func.apply(this.tardis.loyalty());

            this.source.method_9226(() -> class_2561.method_48322(key, fallback, this.player.method_5477(),
                    result.type(), result.level()), false);

            return result;
        }
    }
}
