package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.world.RiftChunkManager;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class RiftChunkCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("rift_chunk")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.rift_chunk", 2))
                .then(method_9247("check")
                        .then(method_9244("position", class_2262.method_9698()).executes(RiftChunkCommand::check)))
                .then(method_9247("get")
                        .then(method_9244("position", class_2262.method_9698()).executes(RiftChunkCommand::get)))
                .then(method_9247("set").then(method_9244("position", class_2262.method_9698())
                        .then(method_9244("artron", DoubleArgumentType.doubleArg()).executes(RiftChunkCommand::set))))));
    }

    private static int check(CommandContext<class_2168> context) {
        class_2338 targetBlockPos = class_2262.method_48299(context, "position");
        class_2168 source = context.getSource();

        boolean isARiftChunk = RiftChunkManager.isRiftChunk(source.method_9225(), targetBlockPos);
        class_2561 isriftchunk = class_2561.method_43471("message.ait.sonic.riftfound");
        class_2561 notriftchunk = class_2561.method_43471("message.ait.sonic.riftnotfound");

        source.method_45068((isARiftChunk ? isriftchunk : notriftchunk));
        return 1;
    }

    private static int get(CommandContext<class_2168> context) {
        class_2338 targetBlockPos = class_2262.method_48299(context, "position");
        class_2168 source = context.getSource();

        boolean isARiftChunk = RiftChunkManager.isRiftChunk(source.method_9225(), targetBlockPos);

        class_3218 world = source.method_9225();

        class_2561 message = !isARiftChunk
                ? class_2561.method_43471("command.ait.riftchunk.cannotgetlevel")
                : class_2561.method_43469("command.ait.riftchunk.getlevel",
                    RiftChunkManager.getInstance(world).getArtron(new class_1923(targetBlockPos)));

        source.method_45068(message);
        return 1;
    }

    private static int set(CommandContext<class_2168> context) {
        class_2338 targetBlockPos = class_2262.method_48299(context, "position");
        class_2168 source = context.getSource();

        class_2561 message;

        if (!RiftChunkManager.isRiftChunk(source.method_9225(), targetBlockPos)) {
            message = class_2561.method_43471("command.ait.riftchunk.cannotsetlevel");
        } else {
            double artron = DoubleArgumentType.getDouble(context, "artron");

            class_3218 world = source.method_9225();
            RiftChunkManager.getInstance(world).setCurrentFuel(new class_1923(targetBlockPos), artron);

            message = class_2561.method_43469("command.ait.riftchunk.setlevel", artron);
        }

        source.method_45068(message);
        return 1;
    }
}
